/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.tomcat.tools;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.main.tomcat.tools.ResolveCertUtils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method Example: startup ,getSignCert, shutdown, restart, closePort openHttpPort,openHttpsPort,getTrustCert,generateP10,getPrivateKeyStore");
            System.out.println("if you use startup please add tomcat path");
            System.out.println("if you use shutdown please add tomcat path");
            System.out.println("if you use restart please add tomcat path");
            System.out.println("if you use getTrustCert please add trustcertP7b path and write path");
            System.out.println("if you use generateP10 please add keySize p10Dn signAlgName and write path");
            System.out.println("if you use getPrivateKeyStore please write keystore.conf path");
            System.out.println("if you use getSignCert  please write Sign.p7b path and write path");
            String os = System.getProperty("os.name");
            System.out.println("System Property is " + os);
            return;
        }
        boolean flag = false;
        if (args[0].equalsIgnoreCase("startup")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar startup /usr/local/tomcat");
                return;
            }
            Main.startupTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("generateSm2P10")) {
            if (args.length == 3) {
                flag = true;
                try {
                    ResolveCertUtils.generateSm2P10(args[1], args[2]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateSm2P10  cn=server,o=xdja,c=cn  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("getSignCert")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar getSignCert /usr/local/Sign.p7b /usr/local");
                return;
            }
            try {
                ResolveCertUtils.getSignCert(args[1], args[2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("shutdown")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar shutdown /usr/local/tomcat");
                return;
            }
            Main.shutdownTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("restart")) {
            flag = true;
            if (args.length != 2 && args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar restartTomcat /usr/local/tomcat");
                return;
            }
            if (args.length == 2) {
                Main.restartTomcat(args[1]);
            } else {
                Main.restartTomcat(args[1], args[2]);
            }
        }
        if (args[0].equalsIgnoreCase("closePort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar closePort /usr/local/tomcat 8888");
                return;
            }
            try {
                Main.closeTomcatPort(args[1], Integer.valueOf(args[2]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpPort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar openHttpPort /usr/local/tomcat 8888");
                return;
            }
            try {
                Main.openHttpPort(args[1], Integer.valueOf(args[2]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpsPort")) {
            if (args.length == 1) {
                flag = true;
                Main.openHttpsPort();
            }
            if (args.length == 2) {
                try {
                    flag = true;
                    Main.openHttpsPort(args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (args[0].equalsIgnoreCase("getPrivateKeyStore")) {
            if (args.length == 2) {
                flag = true;
                try {
                    ResolveCertUtils.getPriKeyStore(args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateP10 2048  cn=server,o=xdja,c=cn sha256withrsa  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("generateP10")) {
            if (args.length == 5) {
                flag = true;
                try {
                    ResolveCertUtils.generateP10(Integer.valueOf(args[1]), args[2], args[3], args[4]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateP10 2048  cn=server,o=xdja,c=cn sha256withrsa  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("getTrustCert")) {
            flag = true;
            String trustSignCert = GMSSLFileUtils.fileToString((File)new File(args[1]), (String)"utf-8");
            try {
                List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(trustSignCert);
                System.out.println("\u89e3\u6790\u8bc1\u4e66\u6210\u529f");
                ResolveCertUtils.writeKeyJson(args[2], "ca.pem", "caCerts", certs);
                System.out.println("\u5199\u51fa\u6587\u4ef6\u5230" + args[2] + "\u6210\u529f");
                System.out.println("\u8bf7\u5c06\u8be5\u6587\u4ef6\u76f8\u5173\u66ff\u6362\u5230\u914d\u7f6e\u6587\u4ef6\u4e2d");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!flag) {
            System.out.println("invalid method , please insert right method");
        }
    }

    private static void startupTomcat(String path) {
        GMSSLTomcatUtils.startupTomcat((String)path);
    }

    private static void shutdownTomcat(String path) {
        GMSSLTomcatUtils.shutdownTomcat((String)path);
    }

    private static void restartTomcat(String path) {
        GMSSLTomcatUtils.restartTomcat((String)path);
    }

    private static void restartTomcat(String path, String shPath) {
        GMSSLTomcatUtils.restartTomcat((String)path, (String)shPath);
    }

    private static void openHttpPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.openHttpPort((String)path, (int)port);
    }

    private static void closeTomcatPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.closeTomcatPort((String)path, (int)port);
    }

    private static void openHttpsPort() {
        String type;
        Scanner in = new Scanner(System.in);
        do {
            System.out.println("Please insert right crypto type Example Bc , YunHsm , Pcie");
        } while (!(type = in.next()).equalsIgnoreCase("Bc") && !type.equalsIgnoreCase("YunHsm") && !type.equalsIgnoreCase("Pcie"));
        System.out.println("you chose the crypto is " + type);
        X509Certificate caCert = null;
        X509Certificate caServerSignCert = null;
        X509Certificate caServerEncCert = null;
        try {
            System.out.println("Please insert RootCert.p7b  path");
            String next = in.next();
            caCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert SignCert.p7b path");
            next = in.next();
            caServerSignCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert EncCert.pem path");
            next = in.next();
            System.out.println("Please insert EncCert.pem keyIndex");
            int keyIndex = in.nextInt();
            caServerEncCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert tomcatPath path");
            String tomcatPath = in.next();
            System.out.println("Please insert https port");
            int port = in.nextInt();
            if (type.equalsIgnoreCase("Bc")) {
                System.out.println("Please insert caServerSignPriKey path");
                next = in.next();
                PrivateKey caServerSignPriKey = GMSSLX509Utils.readPrivateKeyFromPem((String)next);
                System.out.println("Please insert caServerEncPriKey path");
                next = in.next();
                PrivateKey caServerEncPriKey = GMSSLX509Utils.readPrivateKeyFromPem((String)next);
                GMSSLTomcatUtils.openHttpsPortByBC((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (PrivateKey)caServerSignPriKey, (PrivateKey)caServerEncPriKey, (String)tomcatPath, (int)port);
            } else {
                System.out.println("Please insert ca Server PrivateKey Index");
                int index = in.nextInt();
                System.out.println("Please insert ca Server PrivateKey Password");
                String password = in.next();
                if (type.equalsIgnoreCase("YunHsm")) {
                    GMSSLTomcatUtils.openHttpsPortByYunHsm((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (int)index, (String)password, (String)tomcatPath, (int)port);
                } else {
                    GMSSLTomcatUtils.openHttpsPortByPCIE((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (int)index, (String)password, (String)tomcatPath, (int)port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void openHttpsPort(String confPath) throws Exception {
        ResolveCertUtils.addHttpsPort(confPath);
    }
}

