/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.tomcat.tools;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.main.tomcat.tools.KeyStorePropertiesEntry;
import com.xdja.pki.gmssl.main.tomcat.tools.SM2EnvelopedData;
import com.xdja.pki.gmssl.main.tomcat.tools.TomcatPropertiesEntry;
import com.xdja.pki.gmssl.main.tomcat.tools.ToolsCertBean;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveCertUtils {
    private static Logger logger = LoggerFactory.getLogger(ResolveCertUtils.class);

    public static void addHttpsPort(String confPath) throws Exception {
        TomcatPropertiesEntry tomcatProperties = null;
        try {
            tomcatProperties = ResolveCertUtils.getTomcatProperties(confPath);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return;
        }
        System.out.println(tomcatProperties.toString());
        if (tomcatProperties.getKeyType().equalsIgnoreCase("RSA")) {
            ResolveCertUtils.addRSAHttpsPort(tomcatProperties, confPath);
        } else if (tomcatProperties.getKeyType().equalsIgnoreCase("EC")) {
            ResolveCertUtils.addECHttpsPort(tomcatProperties);
        } else if (tomcatProperties.getKeyType().equalsIgnoreCase("BCEC")) {
            ResolveCertUtils.addBCECHttpsPort(tomcatProperties);
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301" + tomcatProperties.getKeyType() + "\u7c7b\u578b\u5bc6\u94a5");
        }
    }

    public static void getSignCert(String signPath, String writePath) throws Exception {
        String signCert = GMSSLFileUtils.fileToString((File)new File(signPath), (String)"utf-8");
        List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(signCert);
        for (X509Certificate certificate : certs) {
            if (GMSSLX509Utils.isCACertificate((X509Certificate)certificate)) continue;
            GMSSLX509Utils.writeCertificateToCer((String)(writePath + "/"), (String)"sign", (X509Certificate)certificate);
            GMSSLX509Utils.writeCertificateToPem((String)(writePath + "/"), (String)"sign", (X509Certificate)certificate);
            System.out.println("\u5df2\u5c06\u8bc1\u4e66\u5199\u5165\u81f3" + writePath + "\u8def\u5f84\u4e0b");
        }
    }

    public static void addRSAHttpsPort(TomcatPropertiesEntry tomcatProperties, String confPath) throws Exception {
        ToolsCertBean certBean = ResolveCertUtils.getCommonCert(tomcatProperties.getEncCertPath(), tomcatProperties.getEncPrivateKey(), tomcatProperties.getSignCertPath(), false);
        GMSSLTomcatUtils.openHttpsPortByJKSWithRSA(certBean.getRootCerts(), (X509Certificate)certBean.getSignCert(), (X509Certificate)certBean.getEncCert(), (PrivateKey)tomcatProperties.getSignPrivateKey(), (PrivateKey)tomcatProperties.getEncPrivateKey(), (String)tomcatProperties.getTomcatPath(), (int)tomcatProperties.getHttpsPort());
        System.out.println("\u5df2\u914d\u7f6e" + tomcatProperties.getTomcatPath() + "\u8def\u5f84\u4e0bTomcat\u7684" + tomcatProperties.getHttpsPort() + "\u7aef\u53e3\u4e3aTLSV1.2\u7c7b\u578b\u7684Https\u901a\u9053");
    }

    public static void addBCECHttpsPort(TomcatPropertiesEntry tomcatProperties) throws Exception {
        ToolsCertBean certBean = ResolveCertUtils.getCommonCert(tomcatProperties.getEncCertPath(), tomcatProperties.getEncPrivateKey(), tomcatProperties.getSignCertPath(), true);
        GMSSLTomcatUtils.openHttpsPortByBC(certBean.getRootCerts(), (X509Certificate)certBean.getSignCert(), (X509Certificate)certBean.getEncCert(), (PrivateKey)tomcatProperties.getSignPrivateKey(), (PrivateKey)tomcatProperties.getEncPrivateKey(), (String)tomcatProperties.getTomcatPath(), (int)tomcatProperties.getHttpsPort());
        System.out.println("\u5df2\u914d\u7f6e" + tomcatProperties.getTomcatPath() + "\u8def\u5f84\u4e0bTomcat\u7684" + tomcatProperties.getHttpsPort() + "\u7aef\u53e3\u4e3aGMSSLV1.1\u7c7b\u578b\u7684Https\u901a\u9053");
    }

    public static void addECHttpsPort(TomcatPropertiesEntry tomcatProperties) throws Exception {
        X509Certificate encCert;
        try {
            byte[] encData = GMSSLFileUtils.readFileToByte((String)tomcatProperties.getEncCertPath());
            String cert = ResolveCertUtils.getEncCertByEnvelopData(tomcatProperties.getEncKeyIndex(), tomcatProperties.getEncPriKey(), encData, true, null);
            encCert = GMSSLX509Utils.readCertificateFromCerByte((byte[])GMSSLByteArrayUtils.base64Decode((String)cert));
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u52a0\u5bc6\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return;
        }
        X509Certificate sign = null;
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            String signCert = GMSSLFileUtils.fileToString((File)new File(tomcatProperties.getSignCertPath()), (String)"utf-8");
            List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(signCert);
            for (X509Certificate cert : certs) {
                if (cert.getSubjectX500Principal().equals(encCert.getSubjectX500Principal())) {
                    sign = cert;
                    continue;
                }
                rootCerts.add(cert);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7b7e\u540d\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return;
        }
        GMSSLTomcatUtils.openHttpsPortByYunHsm(rootCerts, (X509Certificate)sign, (X509Certificate)encCert, (int)tomcatProperties.getEncKeyIndex(), (String)tomcatProperties.getEncPriKey(), (String)tomcatProperties.getTomcatPath(), (int)tomcatProperties.getHttpsPort());
        System.out.println("\u5df2\u914d\u7f6e" + tomcatProperties.getTomcatPath() + "\u8def\u5f84\u4e0bTomcat" + tomcatProperties.getHttpsPort() + "GMSSLSDFYUNHSMV1.1\u7c7b\u578b\u7684Https\u901a\u9053");
    }

    private static ToolsCertBean getCommonCert(String encCertPath, PrivateKey encPrivate, String signCertPath, boolean isEc) throws Exception {
        X509Certificate encCert;
        ToolsCertBean toolsCertBean = new ToolsCertBean();
        try {
            isEc = encPrivate instanceof BCECPrivateKey;
            byte[] encData = GMSSLFileUtils.readFileToByte((String)encCertPath);
            String cert = ResolveCertUtils.getEncCertByEnvelopData(null, null, encData, isEc, encPrivate);
            encCert = GMSSLX509Utils.readCertificateFromCerByte((byte[])GMSSLByteArrayUtils.base64Decode((String)cert));
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u52a0\u5bc6\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            throw new Exception("\u89e3\u6790\u52a0\u5bc6\u8bc1\u4e66\u94fe\u5931\u8d25", e);
        }
        X509Certificate sign = null;
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            String signCert = GMSSLFileUtils.fileToString((File)new File(signCertPath), (String)"utf-8");
            List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(signCert);
            for (X509Certificate cert : certs) {
                if (cert.getSubjectX500Principal().equals(encCert.getSubjectX500Principal())) {
                    sign = cert;
                    continue;
                }
                rootCerts.add(cert);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7b7e\u540d\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            throw new Exception("\u89e3\u6790\u7b7e\u540d\u8bc1\u4e66\u94fe\u5931\u8d25", e);
        }
        toolsCertBean.setEncCert(encCert);
        toolsCertBean.setSignCert(sign);
        toolsCertBean.setRootCerts(rootCerts);
        return toolsCertBean;
    }

    public X509Certificate getEncCert(int keyIndex, String priKeyPwd, String path) throws Exception {
        byte[] data = GMSSLFileUtils.readFileToByte((String)path);
        String cert = ResolveCertUtils.getEncCertByEnvelopData(keyIndex, priKeyPwd, data, true, null);
        return GMSSLX509Utils.readCertificateFromCerByte((byte[])GMSSLByteArrayUtils.base64Decode((String)cert));
    }

    public static List<X509Certificate> getCertsByCertChain(String p7b) throws CMSException, CertificateException {
        p7b = p7b.replaceFirst("-----BEGIN PKCS7-----", "");
        p7b = p7b.replaceFirst("-----END PKCS7-----", "");
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CMSSignedData cmsSignedData = new CMSSignedData(Base64.decode((String)p7b));
        Store store = cmsSignedData.getCertificates();
        Collection collection = store.getMatches(null);
        for (X509CertificateHolder x509CertificateHolder : collection) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
            certificateList.add(x509Certificate);
        }
        return certificateList;
    }

    public static TomcatPropertiesEntry getTomcatProperties(String confPath) throws IOException {
        TomcatPropertiesEntry propertiesEntry = new TomcatPropertiesEntry();
        File file = new File(confPath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject tomcatProperties = dataJson.getJSONObject("Tomcat");
        propertiesEntry.setTomcatPath(tomcatProperties.getString("tomcatPath"));
        propertiesEntry.setRootCertPath(tomcatProperties.getString("rootCertPath"));
        propertiesEntry.setSignCertPath(tomcatProperties.getString("signCertPath"));
        propertiesEntry.setEncCertPath(tomcatProperties.getString("encCertPath"));
        propertiesEntry.setEncKeyIndex(tomcatProperties.getInteger("encKeyIndex"));
        propertiesEntry.setEncPriKey(tomcatProperties.getString("encPriKey"));
        propertiesEntry.setHttpsPort(tomcatProperties.getInteger("httpsPort"));
        propertiesEntry.setCryptoType(tomcatProperties.getString("cryptoType"));
        propertiesEntry.setKeyType(tomcatProperties.getString("keyType"));
        propertiesEntry.setEncPriKeyPath(tomcatProperties.getString("encPriKeyPath"));
        propertiesEntry.setSignPriKeyPath(tomcatProperties.getString("signPriKeyPath"));
        return propertiesEntry;
    }

    public static String getEncCertByEnvelopData(Integer keyIndex, String priKeyPwd, byte[] data, boolean isEc, PrivateKey privateKey) throws Exception {
        SM2EnvelopedData envelopedData = SM2EnvelopedData.getInstance(Base64.decode((byte[])data));
        ASN1Set recipientInfos = envelopedData.getRecipientInfos();
        ASN1Encodable objectAt = recipientInfos.getObjectAt(0);
        ASN1Sequence derSequence = (ASN1Sequence)recipientInfos.getObjectAt(0);
        DEROctetString pwdSymmetricKey = null;
        for (int i = 0; i < derSequence.size(); ++i) {
            ASN1Encodable object = null;
            object = derSequence.getObjectAt(i);
            if (!(object instanceof DEROctetString)) continue;
            pwdSymmetricKey = (DEROctetString)object;
        }
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        ASN1OctetString encryptedContent = encryptedContentInfo.getEncryptedContent();
        String base64Enc = Base64.toBase64String((byte[])pwdSymmetricKey.getOctets());
        String symmetricKey = isEc ? (privateKey != null ? GMSSLSM2EncryptUtils.decryptASN1ByBC((PrivateKey)privateKey, (String)base64Enc) : GMSSLSM2EncryptUtils.decryptASN1ByYunhsm((int)keyIndex, (String)priKeyPwd, (String)base64Enc)) : GMSSLRSAEncryptUtils.decryptDataPKCS1ByBC((PrivateKey)privateKey, (String)base64Enc);
        return GMSSLSM4ECBEncryptUtils.decryptByBCWithPKCS7Padding((String)symmetricKey, (String)Base64.toBase64String((byte[])encryptedContent.getOctets()));
    }

    public static void writeKeyJson(String path, String fileName, String name, List<X509Certificate> certs) {
        ArrayList<String> content = new ArrayList<String>();
        for (int i = 0; i < certs.size(); ++i) {
            try {
                content.add(ResolveCertUtils.getPemObjectString(certs.get(i)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(content);
        result.put(name, (Object)jsonArray);
        System.out.println(result.toJSONString());
        ResolveCertUtils.createJsonFile(result.toString(), path, fileName);
    }

    public static String getPemObjectString(Object obj) throws Exception {
        StringWriter stringWriter = new StringWriter();
        GMSSLX509Utils.writePEM((Object)obj, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static boolean createJsonFile(String jsonString, String filePath, String fileName) {
        boolean flag = true;
        String fullPath = filePath + File.separator + fileName;
        try {
            File file = new File(fullPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            if (jsonString.indexOf("'") != -1) {
                jsonString = jsonString.replaceAll("'", "\\'");
            }
            if (jsonString.indexOf("\"") != -1) {
                jsonString = jsonString.replaceAll("\"", "\\\"");
            }
            if (jsonString.indexOf("\r\n") != -1) {
                jsonString = jsonString.replaceAll("\r\n", "\\u000d\\u000a");
            }
            if (jsonString.indexOf("\n") != -1) {
                jsonString = jsonString.replaceAll("\n", "\\u000a");
            }
            jsonString = GMSSLYunHsmUtils.formatJson((String)jsonString);
            OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonString);
            ((Writer)write).flush();
            ((Writer)write).close();
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public static void generateP10(int keySize, String dn, String signAlgName, String path) throws Exception {
        System.out.println("\u5c06\u968f\u673a\u751f\u6210" + keySize + "bits\u7684RSA\u516c\u94a5");
        System.out.println("\u751f\u6210\u7684P10 DN\u4e3a" + dn);
        System.out.println("\u751f\u6210\u7684P10 \u7b7e\u540d\u7b97\u6cd5\u4e3a" + signAlgName.toUpperCase());
        KeyPair signKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)keySize);
        KeyPair encKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)keySize);
        PKCS10CertificationRequest signP10 = GMSSLP10Utils.generateP10SignByBC((String)dn, (PublicKey)signKeyPair.getPublic(), (PrivateKey)signKeyPair.getPrivate(), (String)signAlgName);
        GMSSLX509Utils.writePublicKeyToDat((String)path, (String)"server_enc.dat", (PublicKey)encKeyPair.getPublic());
        GMSSLP10Utils.writeP10ToFile((String)path, (String)"server_sign", (Object)signP10);
        GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)"sign_key", (PrivateKey)signKeyPair.getPrivate());
        GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)"enc_key", (PrivateKey)encKeyPair.getPrivate());
        System.out.println("\u5df2\u751f\u6210\u76f8\u5173\u6587\u4ef6\u5728" + path + "\u8def\u5f84\u4e0b");
    }

    public static void generateSm2P10(String dn, String path) throws Exception {
        System.out.println("\u5c06\u968f\u673a\u751f\u6210SM2\u516c\u94a5");
        System.out.println("\u751f\u6210\u7684P10 DN\u4e3a" + dn);
        KeyPair signKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        KeyPair encKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PKCS10CertificationRequest signP10 = GMSSLP10Utils.generateP10SignByBC((String)dn, (PublicKey)signKeyPair.getPublic(), (PrivateKey)signKeyPair.getPrivate(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLX509Utils.writePublicKeyToDat((String)path, (String)"server_enc.dat", (PublicKey)encKeyPair.getPublic());
        GMSSLP10Utils.writeP10ToFile((String)path, (String)"server_sign", (Object)signP10);
        GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)"sign_key", (PrivateKey)signKeyPair.getPrivate());
        GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)"enc_key", (PrivateKey)encKeyPair.getPrivate());
        System.out.println("\u5df2\u751f\u6210\u76f8\u5173\u6587\u4ef6\u5728" + path + "\u8def\u5f84\u4e0b");
    }

    public static void getPriKeyStore(String confPath) throws Exception {
        KeyStorePropertiesEntry keyStorePropertiesEntry = null;
        try {
            keyStorePropertiesEntry = ResolveCertUtils.getKeyStoreEntry(confPath);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return;
        }
        System.out.println(keyStorePropertiesEntry.toString());
        ToolsCertBean certBean = ResolveCertUtils.getCommonCert(keyStorePropertiesEntry.getEncCertPath(), keyStorePropertiesEntry.getEncPrivateKey(), keyStorePropertiesEntry.getSignCertPath(), false);
        KeyStore keyStore = keyStorePropertiesEntry.getEncPrivateKey() instanceof BCECPrivateKey ? GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithBKS((String)"password", (X509Certificate)certBean.getRootCerts().get(0), (String)"sign", (PrivateKey)keyStorePropertiesEntry.getSignPrivateKey(), (X509Certificate)certBean.getSignCert(), (String)"enc", (PrivateKey)keyStorePropertiesEntry.getEncPrivateKey(), (X509Certificate)certBean.getEncCert()) : GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithJKS((String)"password", (X509Certificate)certBean.getRootCerts().get(0), (String)"sign", (PrivateKey)keyStorePropertiesEntry.getSignPrivateKey(), (X509Certificate)certBean.getSignCert(), (String)"enc", (PrivateKey)keyStorePropertiesEntry.getEncPrivateKey(), (X509Certificate)certBean.getEncCert());
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)keyStore, (String)"password", (String)keyStorePropertiesEntry.getWritePath(), (String)"privateKey");
        System.out.println("\u5df2\u751f\u6210\u76f8\u5173\u6587\u4ef6privateKey.keystore\u5728" + keyStorePropertiesEntry.getWritePath() + "\u8def\u5f84\u4e0b");
    }

    public static KeyStorePropertiesEntry getKeyStoreEntry(String confPath) throws IOException {
        KeyStorePropertiesEntry propertiesEntry = new KeyStorePropertiesEntry();
        File file = new File(confPath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject tomcatProperties = dataJson.getJSONObject("keystore");
        propertiesEntry.setWritePath(tomcatProperties.getString("writePath"));
        propertiesEntry.setSignCertPath(tomcatProperties.getString("signCertPath"));
        propertiesEntry.setEncCertPath(tomcatProperties.getString("encCertPath"));
        propertiesEntry.setEncPriKeyPath(tomcatProperties.getString("encPriKeyPath"));
        propertiesEntry.setSignPriKeyPath(tomcatProperties.getString("signPriKeyPath"));
        return propertiesEntry;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

