/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.tomcat.tools;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;

public class SM2EnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;

    public SM2EnvelopedData(ASN1Integer version, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo) {
        this.version = version;
        this.recipientInfos = recipientInfos;
        this.encryptedContentInfo = encryptedContentInfo;
    }

    public SM2EnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (ASN1Integer)seq.getObjectAt(index++);
        ASN1Encodable tmp = seq.getObjectAt(index++);
        this.recipientInfos = ASN1Set.getInstance((Object)tmp);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance((Object)seq.getObjectAt(index++));
    }

    public static SM2EnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2EnvelopedData.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static SM2EnvelopedData getInstance(Object obj) {
        if (obj instanceof SM2EnvelopedData) {
            return (SM2EnvelopedData)((Object)obj);
        }
        if (obj != null) {
            return new SM2EnvelopedData(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.recipientInfos);
        v.add((ASN1Encodable)this.encryptedContentInfo);
        return new BERSequence(v);
    }
}

