/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLAES128ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLKeKUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1CBCEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4CBCEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.gmssl.x509.utils.bean.HsmInfoEntry;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliYunHsmDemo {
    private static Logger logger = LoggerFactory.getLogger(AliYunHsmDemo.class);
    private static int SM2_KEY_INDEX = 1;
    private static int RSA_KEY_INDEX = 21;
    private static int RSA_KEY_INDEX_1024 = 21;
    private static String PASSWORD = "xdja1234";
    private static int SM1_INDEX = 1;
    private static int SM4_INDEX = 1;
    private static int AES_INDEX = 1;

    public static void main(String[] args) {
        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
        int valueOf = 9;
        if (valueOf == 1) {
            GMSSLHsmUtils.initYunHsmConfigAndTestConnect((String)"192.168.10.10", (int)8019, (String)"SJJ1507");
        }
        if (valueOf == 2) {
            GMSSLHsmUtils.testConnect();
        }
        if (valueOf == 3) {
            GMSSLHsmUtils.testConnect((String)"192.168.10.10", (int)8019, (String)"SJJ1507");
        }
        if (valueOf == 4) {
            String confPath = GMSSLHsmUtils.getConfPath((boolean)true);
            System.out.println(confPath);
        }
        if (valueOf == 5) {
            try {
                HsmInfoEntry jntaDeviceInfo = GMSSLHsmUtils.getConfigInfo();
                System.out.println(jntaDeviceInfo);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25,", (Throwable)e);
            }
        }
        AliYunHsmDemo.runTask();
    }

    private static void runTask() {
        AliYunHsmDemo.testGenerateRandom();
        AliYunHsmDemo.testSM1ECB();
        AliYunHsmDemo.testSM1ECBPkcs7();
        AliYunHsmDemo.testSM1CBC();
        AliYunHsmDemo.testSM1CBCPkcs7();
        AliYunHsmDemo.testSM4Ecb();
        AliYunHsmDemo.testSM4EcbPkcs7();
        AliYunHsmDemo.testSM4Cbc();
        AliYunHsmDemo.testSM4CbcPkcs7();
        AliYunHsmDemo.testAes128();
        AliYunHsmDemo.testAes128Pkcs7();
        AliYunHsmDemo.testSm2Generate();
        AliYunHsmDemo.testSM2Sign();
        AliYunHsmDemo.testSM2Encyrpt();
        AliYunHsmDemo.testSm2Export();
        AliYunHsmDemo.testSm2Generate();
        AliYunHsmDemo.testSM3Hash();
        AliYunHsmDemo.testSha1Hash();
        AliYunHsmDemo.testSha256Hash();
        AliYunHsmDemo.testRsaGenerate2048();
        AliYunHsmDemo.testRsaExport(RSA_KEY_INDEX);
        AliYunHsmDemo.rsaSignWithAlg(RSA_KEY_INDEX, GMSSLSignatureAlgorithm.SHA256_WITH_RSA);
        AliYunHsmDemo.rsaSignWithAlg(RSA_KEY_INDEX, GMSSLSignatureAlgorithm.SHA1_WITH_RSA);
        AliYunHsmDemo.testSM1Kek();
        AliYunHsmDemo.testSM4Kek();
    }

    public static void testGenerateRandom() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate random <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = GMSSLRandomUtils.generateRandom((int)16);
            logger.info("random {}", (Object)data);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate random success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test generate random error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM1Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek((int)SM1_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"key", (byte[])key);
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encryptWithKek((byte[])key, (int)SM1_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt", (byte[])encrypt);
            byte[] decrypt = GMSSLSM1ECBEncryptUtils.decryptWithKek((byte[])key, (int)SM1_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"decrypt", (byte[])decrypt);
            logger.info("key {}", (Object)Hex.toHexString((byte[])key));
            logger.info("encrypt {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt {}", (Object)Hex.toHexString((byte[])decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", (Object)b);
            if (!b) {
                logger.error("test SM1 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  kek success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test SM1 kek error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM4Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek((int)SM4_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM4_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"key", (byte[])key);
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encryptWithKek((byte[])key, (int)SM4_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt", (byte[])encrypt);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decryptWithKek((byte[])key, (int)SM4_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"decrypt", (byte[])decrypt);
            logger.info("key {}", (Object)Hex.toHexString((byte[])key));
            logger.info("encrypt {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt {}", (Object)Hex.toHexString((byte[])decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", (Object)b);
            if (!b) {
                logger.error("test SM4 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4  kek success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test SM4 kek error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testAes128Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test aes128 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek((int)AES_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_AES_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"key", (byte[])key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encryptWithKek((byte[])key, (int)AES_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt", (byte[])encrypt);
            byte[] decrypt = GMSSLAES128ECBEncryptUtils.decryptWithKek((byte[])key, (int)AES_INDEX, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM1_ECB, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, (String)"decrypt", (byte[])decrypt);
            logger.info("key {}", (Object)Hex.toHexString((byte[])key));
            logger.info("encrypt {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt {}", (Object)Hex.toHexString((byte[])decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", (Object)b);
            if (!b) {
                logger.error("test aes128 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test aes128  kek success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test aes128 kek error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM1ECB() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", (Object)decrypt1);
            logger.info("encrypt {}", (Object)encrypt);
            logger.info("key {}", (Object)key);
            logger.info("assert {}", (Object)encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  ecb success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("testSM1  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM1ECBPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", (Object)decrypt1);
            logger.info("encrypt {}", (Object)encrypt);
            logger.info("key {}", (Object)key);
            logger.info("assert {}", (Object)encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb pkcs7 success<<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("testSM1  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM1CBC() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 cbc <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1CBCEncryptUtils.encrypt((byte[])key, (byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt1 = GMSSLSM1CBCEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", (Object)decrypt1);
            logger.info("encrypt {}", (Object)encrypt);
            logger.info("key {}", (Object)key);
            logger.info("assert {}", (Object)encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  cbc success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("testSM1  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM1CBCPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 cbc pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1CBCEncryptUtils.encrypt((byte[])key, (byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt1 = GMSSLSM1CBCEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", (Object)decrypt1);
            logger.info("encrypt {}", (Object)encrypt);
            logger.info("key {}", (Object)key);
            logger.info("assert {}", (Object)encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  cbc pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("testSM1  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM2Sign() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SM2Sign <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = "test sm2 sign ".getBytes();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(SM2_KEY_INDEX, PASSWORD);
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)SM2_KEY_INDEX, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
            byte[] sign = GMSSLECSignUtils.sign((PrivateKey)sdfPrivateKey, (byte[])data, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
            boolean verify = GMSSLECSignUtils.verify((PublicKey)publicKey, (byte[])data, (byte[])sign, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
            logger.info("\u5bc6\u7801\u673a\u7b7e\u540d {} ,", (Object)Hex.toHexString((byte[])sign));
            logger.info("\u5bc6\u7801\u673a\u9a8c\u7b7e\u7ed3\u679c {} ,", (Object)verify);
            if (!verify) {
                logger.error("test SM2Sign error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SM2Sign  success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test SM2Sign", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM2Encyrpt() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm2 encyrpt <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = "test sm2 encrypt ".getBytes();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(SM2_KEY_INDEX, PASSWORD);
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)SM2_KEY_INDEX, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
            byte[] encrypt = GMSSLSM2EncryptUtils.encrypt((PublicKey)publicKey, (byte[])data);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] decrypt = GMSSLSM2EncryptUtils.decrypt((PrivateKey)sdfPrivateKey, (byte[])encrypt);
            logger.info("\u52a0\u5bc6\u6570\u636e\u539f\u6587 {}", (Object)Hex.toHexString((byte[])data));
            logger.info("\u5bc6\u7801\u673a\u52a0\u5bc6\u540e\u6570\u636e {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("\u5bc6\u7801\u673a\u89e3\u5bc6\u540e\u6570\u636e {}", (Object)Hex.toHexString((byte[])decrypt));
            boolean b1 = Arrays.equals(data, decrypt);
            if (!b1) {
                logger.error("test SM2Encyrpt error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm2 encyrpt success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm2 encyrpt error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM3Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm3 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode((byte[])"12352355345345334534534535236746545635345354345354".getBytes());
            String base64Hash = "iwbxq6mUNdJxi7VrDRU1j3iaZich6fXaK41Qc8RVl00=";
            String digestByBC = GMSSLSM3DigestUtils.digestByBC((String)data);
            String digestByYun = GMSSLSM3DigestUtils.digestByYunhsm((String)data);
            logger.info("BC\u7ecf\u8fc7SM3\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByBC);
            logger.info("\u5bc6\u7801\u673a\u7ecf\u8fc7SM3\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByYun);
            logger.info("SM3\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)base64Hash);
            if (!digestByBC.equalsIgnoreCase(base64Hash) || !digestByBC.equalsIgnoreCase(digestByYun)) {
                logger.error("test SM3 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm3 digest success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm3 digest  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSha1Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sha1 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode((byte[])"12352355345345334534534535236746545635345354345354".getBytes());
            String digestByBC = GMSSLSHA1DigestUtils.digestByBC((String)data);
            String digestByYun = GMSSLSHA1DigestUtils.digestByYunHsm((String)data);
            logger.info("BC\u7ecf\u8fc7SHA1\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByBC);
            logger.info("\u5bc6\u7801\u673a\u7ecf\u8fc7SHA1\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByYun);
            boolean b = digestByBC.equalsIgnoreCase(digestByYun);
            logger.info("assert {}", (Object)b);
            if (!b) {
                logger.error("test SHA1 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sha1 digest success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm3 digest  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSha256Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SHA256 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode((byte[])"12352355345345334534534535236746545635345354345354".getBytes());
            String digestByBC = GMSSLSHA256DigestUtils.digestByBC((String)data);
            String digestByYun = GMSSLSHA256DigestUtils.digestByYunHsm((String)data);
            logger.info("BC\u7ecf\u8fc7SHA256\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByBC);
            logger.info("\u5bc6\u7801\u673a\u7ecf\u8fc7SHA256\u6458\u8981\u540e\u7684\u6570\u636e\u4e3a{}", (Object)digestByYun);
            boolean b = digestByBC.equalsIgnoreCase(digestByYun);
            logger.info("assert {}", (Object)b);
            if (!b) {
                logger.error("test SHA256 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SHA256 digest success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test SHA256 digest  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM4Ecb() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 ecb <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean b1 = Arrays.equals(decrypt, data);
            logger.info("encrypt by hsm {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt by hsm {}", (Object)Hex.toHexString((byte[])decrypt));
            if (!b1) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 ecb success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm4 ecb error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM4EcbPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean b1 = Arrays.equals(decrypt, data);
            logger.info("encrypt by hsm {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt by hsm {}", (Object)Hex.toHexString((byte[])decrypt));
            if (!b1) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm4 pkcs7  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM4Cbc() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4CBCEncryptUtils.encrypt((byte[])key, (byte[])data, (byte[])iv, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding, (boolean)false);
            byte[] decrypt = GMSSLSM4CBCEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (byte[])iv, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding, (boolean)false);
            boolean b1 = Arrays.equals(decrypt, data);
            logger.info("encrypt by hsm {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt by hsm {}", (Object)Hex.toHexString((byte[])decrypt));
            logger.info("assert decrypt  decryptByBc{}", (Object)b1);
            if (!b1) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm4 cbc error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSM4CbcPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4CBCEncryptUtils.encrypt((byte[])key, (byte[])data, (byte[])iv, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (boolean)false);
            byte[] decrypt = GMSSLSM4CBCEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (byte[])iv, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (boolean)false);
            boolean b1 = Arrays.equals(decrypt, data);
            logger.info("encrypt by hsm {}", (Object)Hex.toHexString((byte[])encrypt));
            logger.info("decrypt by hsm {}", (Object)Hex.toHexString((byte[])decrypt));
            logger.info("assert decrypt  decryptByBc{}", (Object)b1);
            if (!b1) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc pkcs7 cbcsuccess <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test sm4 cbc pkcs7 error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testAes128() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLRandomUtils.generateRandom((int)16);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"key", (byte[])key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encrypt", (byte[])encrypt);
            byte[] decryptByHsm = GMSSLAES128ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decryptByHsm", (byte[])decryptByHsm);
            boolean b1 = Arrays.equals(key, decryptByHsm);
            logger.info("assert key decryptByHsm {}", (Object)b1);
            if (!b1) {
                logger.error("test aes128 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test Aes128  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testAes128Pkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLRandomUtils.generateRandom((int)16);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"key", (byte[])key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"encrypt", (byte[])encrypt);
            byte[] decryptByHsm = GMSSLAES128ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"decryptByHsm", (byte[])decryptByHsm);
            boolean b1 = Arrays.equals(key, decryptByHsm);
            logger.info("assert key decryptByHsm {}", (Object)b1);
            if (!b1) {
                logger.error("test aes128 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("test Aes128 pkcs7 error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testRsaGenerate2048() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByYunHsm((int)2048);
            logger.info("keypair private {}", (Object)keyPair.getPrivate());
            logger.info("keypair public {}", (Object)keyPair.getPublic());
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("rsaGenerate2048 error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testRsaGenerate1024() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByYunHsm((int)1024);
            logger.info("keypair private {}", (Object)keyPair.getPrivate());
            logger.info("keypair public {}", (Object)keyPair.getPublic());
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("rsaGenerate2048 error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void rsaSignWithAlg(int index, GMSSLSignatureAlgorithm algorithm) {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsa sign {} <<<<<<<<<<<<<<<<<<<<<<", (Object)algorithm);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode((String)"12345678900123456789");
            byte[] signByHsm = GMSSLRSASignUtils.sign((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)PASSWORD), (byte[])data, (String)algorithm.getSigAlgName());
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey signPublic = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)false);
            boolean b = GMSSLRSASignUtils.verify((PublicKey)signPublic, (byte[])data, (byte[])signByHsm, (String)algorithm.getSigAlgName());
            logger.info("RSA verify By Hsm {}", (Object)b);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsa sign {} success <<<<<<<<<<<<<<<<<<<<<<", (Object)algorithm);
            if (!b) {
                logger.error("RSA sign {} error", (Object)algorithm);
                System.exit(0);
            }
        }
        catch (Exception e) {
            logger.error("RSA sign with alg error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSm2Generate() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate sm2 keypair <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
            logger.info("keypair private {}", (Object)keyPair.getPrivate());
            logger.info("keypair public {}", (Object)keyPair.getPublic());
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate sm2 keypair success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("generate sm2 key pair error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testSm2Export() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export sm2 key  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encryptKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)SM2_KEY_INDEX, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)SM2_KEY_INDEX, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
            logger.info("encryptKey public {}", (Object)encryptKey);
            logger.info("signKey public {}", (Object)signKey);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export sm2 key  success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("export sm2 key  error", (Throwable)e);
            System.exit(0);
        }
    }

    public static void testRsaExport(int index) {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export rsa key  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encryptKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)true);
            PublicKey signKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)false);
            logger.info("encryptKey public {}", (Object)encryptKey);
            logger.info("signKey public {}", (Object)signKey);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export rsa key  success <<<<<<<<<<<<<<<<<<<<<<");
        }
        catch (Exception e) {
            logger.error("export rsa key  error", (Throwable)e);
            System.exit(0);
        }
    }
}

