/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import java.io.File;

public class KeyAccessTest {
    public static void main(String[] args) throws Exception {
        int value = Integer.valueOf(args[0]);
        if (value == 1) {
            KeyAccessTest.testThread();
        }
        if (value == 2) {
            KeyAccessTest.testNewTest(true);
        }
        if (value == 3) {
            KeyAccessTest.testNewTest(false);
        }
        if (value == 4) {
            KeyAccessTest.testUtils();
        }
        if (value == 5) {
            KeyAccessTest.testUtilsError();
        }
    }

    public static void testThread() {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 2; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 200; ++i) {
                        boolean a1234567 = GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf((SdfCryptoType)SdfCryptoType.YUNHSM, (int)1, (String)"a1234567");
                        System.out.println(a1234567);
                    }
                }
            });
            thread.start();
        }
    }

    public static void testNewTest(boolean isRelease) throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 10; ++i) {
            SdfApi sdfApi = new SdfApi();
            long[] dev = new long[]{0L};
            long[] ses = new long[]{0L};
            String confPath = GMSSLHsmUtils.getConfPath((boolean)false) + File.separator + "etc" + File.separator + "xdsdfjni.json";
            System.out.println(confPath);
            int ret = sdfApi.openDeviceWithPath(confPath, dev);
            YunhsmSdfSDKUtils.checkRet((String)"openDeviceWithPath", (int)ret, (long)dev[0], (long)0L);
            ret = sdfApi.initialize(dev[0], confPath.getBytes());
            YunhsmSdfSDKUtils.checkRet((String)"initialize", (int)ret, (long)dev[0], (long)0L);
            ret = sdfApi.openSession(dev[0], ses);
            YunhsmSdfSDKUtils.checkRet((String)"openSession", (int)ret, (long)dev[0], (long)0L);
            int accessRight = sdfApi.getPrivateKeyAccessRight(ses[0], 1, "a1234568".getBytes(), 8);
            YunhsmSdfSDKUtils.checkRet((String)"getPrivateKeyAccessRight", (int)accessRight, (long)dev[0], (long)0L);
            if (isRelease) {
                ret = sdfApi.closeSession(ses[0]);
                YunhsmSdfSDKUtils.checkRet((String)"closeSession", (int)ret, (long)dev[0], (long)0L);
                ret = sdfApi.closeDevice(dev[0]);
                YunhsmSdfSDKUtils.checkRet((String)"closeDevice", (int)ret, (long)dev[0], (long)0L);
            }
            System.out.println("#######################" + accessRight);
        }
    }

    public static void testUtils() throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 100; ++i) {
            boolean check = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)1, (String)"a1234567");
            System.out.println(check);
        }
    }

    public static void testUtilsError() throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 100; ++i) {
            boolean check = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)1, (String)"a1254567");
            System.out.println(check);
        }
    }
}

