/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLECKeyUtils {
    public static final String SM2p256;
    public static final String NISTp256;

    public static KeyPair generateECKeyPairByBC(String stdName) throws Exception {
        return GMSSLECUtils.generateKeyPair((String)stdName);
    }

    public static SdfECCKeyPair generateECKeyPairByYunHsm(String stdName) throws Exception {
        SdfECCKeyPair sdfECCKeyPair;
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
        if (stdName.equalsIgnoreCase(GMSSLECUtils.SM2p256)) {
            sdfECCKeyPair = sdfSDK.generateKeyPairEcc(AlgId.SGD_SM2);
        } else if (stdName.equalsIgnoreCase(GMSSLECUtils.NISTp256)) {
            sdfECCKeyPair = sdfSDK.generateKeyPairEcc(AlgId.SGD_ECC_NISTP256);
        } else {
            throw new Exception("unSupport " + stdName + " alg");
        }
        sdfSDK.release();
        return sdfECCKeyPair;
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password.getBytes());
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.YUNHSM, stdName);
        PublicKey publicKey = sdfECKey.exportSignPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.PCIE, stdName);
        PublicKey publicKey = sdfECKey.exportSignPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.YUNHSM, stdName);
        PublicKey publicKey = sdfECKey.exportEncryptPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index, String stdName) throws SdfSDKException {
        SdfECKey sdfECKey = new SdfECKey(SdfCryptoType.PCIE, stdName);
        PublicKey publicKey = sdfECKey.exportEncryptPublicKey(index);
        sdfECKey.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        SM2p256 = GMNamedCurves.getName((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        NISTp256 = NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1);
    }
}

