/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLSdfSM2SignerUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLECSignUtils {
    public static String signByBC(PrivateKey privateKey, String base64Data, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sig = GMSSLECSignUtils.signByBC(privateKey, data, signAlgName);
        return GMSSLByteArrayUtils.base64Encode((byte[])sig);
    }

    public static byte[] signByBC(PrivateKey privateKey, byte[] data, String signAlgName) throws Exception {
        return GMSSLBCSignUtils.generateSignature((String)signAlgName, (PrivateKey)privateKey, (byte[])data);
    }

    public static boolean verifyByBC(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws Exception {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLECSignUtils.verifyByBC(publicKey, data, sign, signAlgName);
    }

    public static boolean verifyByBC(PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLBCSignUtils.verifySignature((String)signAlgName, (PublicKey)publicKey, (byte[])data, (byte[])sign);
    }

    public static String signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, String base64Data, String signAlgName) throws CryptoException, SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sig = GMSSLECSignUtils.signBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data, signAlgName);
        return GMSSLByteArrayUtils.base64Encode((byte[])sig);
    }

    public static byte[] signByYunHsm(int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws Exception {
        return GMSSLECSignUtils.signBySdf(SdfCryptoType.YUNHSM, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static boolean verifyByYunHsm(PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws Exception {
        return GMSSLECSignUtils.verifyByHSM(null, publicKey, data, sign, signAlgName);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws CryptoException, SdfSDKException {
        return GMSSLECSignUtils.signBySdf(sdfCryptoType, null, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signBySdfWithUserId(SdfCryptoType sdfCryptoType, int privateKeyIndex, String privateKeyPassword, byte[] userId, byte[] data, String signAlgName) throws CryptoException, SdfSDKException {
        return GMSSLECSignUtils.signBySdf(sdfCryptoType, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static boolean verifyByYunHsm(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws SdfSDKException {
        return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.YUNHSM, publicKey, base64Data, base64Sign, signAlgName);
    }

    public static boolean verifyByPcie(PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws SdfSDKException {
        return GMSSLECSignUtils.verifyBySdf(SdfCryptoType.PCIE, publicKey, base64Data, base64Sign, signAlgName);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, String base64Data, String base64Sign, String signAlgName) throws SdfSDKException {
        byte[] data = GMSSLByteArrayUtils.base64Decode((String)base64Data);
        byte[] sign = GMSSLByteArrayUtils.base64Decode((String)base64Sign);
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, publicKey, data, sign, signAlgName);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws SdfSDKException {
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, null, publicKey, data, sign, signAlgName);
    }

    public static boolean verifyBySdfWithUserId(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] userId, byte[] data, byte[] sign, String signAlgName) throws SdfSDKException {
        return GMSSLECSignUtils.verifyBySdf(sdfCryptoType, userId, publicKey, data, sign, signAlgName);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws CryptoException, SdfSDKException {
        SdfECBaseSigner signer = GMSSLSdfSM2SignerUtils.generateSM2Signer(sdfCryptoType, signAlgName);
        return GMSSLECSignUtils.signBySdf(signer, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signByYunHsm(byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws CryptoException, SdfSDKException {
        SdfECSigner signer = new SdfECSigner(SdfCryptoType.YUNHSM, signAlgName);
        return GMSSLECSignUtils.signBySdf((SdfECBaseSigner)signer, userId, privateKeyIndex, privateKeyPassword, data, signAlgName);
    }

    public static byte[] signBySdf(SdfECBaseSigner signer, byte[] userId, int privateKeyIndex, String privateKeyPassword, byte[] data, String signAlgName) throws CryptoException, SdfSDKException {
        return GMSSLSM2SignUtils.signBySdf(signer, userId, privateKeyIndex, privateKeyPassword, data);
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws SdfSDKException {
        SdfSM2SignerSM3 signer = new SdfSM2SignerSM3(sdfCryptoType, signAlgName);
        return GMSSLECSignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyByHSM(byte[] userId, PublicKey publicKey, byte[] data, byte[] sign, String signAlgName) throws SdfSDKException {
        SdfECSigner signer = new SdfECSigner(SdfCryptoType.YUNHSM, signAlgName);
        return GMSSLECSignUtils.verifyBySdf((SdfECBaseSigner)signer, userId, publicKey, data, sign);
    }

    public static boolean verifyBySdf(SdfECBaseSigner signer, byte[] userId, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        return GMSSLSM2SignUtils.verifyBySdf(signer, userId, publicKey, data, sign);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

