/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSAKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSASigner;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public class GMSSLRSASignUtils {
    public static String signByBC(String algorithm, PrivateKey privateKey, String data) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLRSAUtils.generateSignature((String)algorithm, (PrivateKey)privateKey, (byte[])dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static boolean verifyByBC(String algorithm, PublicKey publicKey, String data, String sign) throws Exception {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSAUtils.verifySignature((String)algorithm, (PublicKey)publicKey, (byte[])dataBytes, (byte[])signBytes);
    }

    public static byte[] signByBC(String algorithm, PrivateKey privateKey, byte[] data) throws Exception {
        return GMSSLRSAUtils.generateSignature((String)algorithm, (PrivateKey)privateKey, (byte[])data);
    }

    public static boolean verifyByBC(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws Exception {
        return GMSSLRSAUtils.verifySignature((String)algorithm, (PublicKey)publicKey, (byte[])data, (byte[])sign);
    }

    public static byte[] signByYunHsm(String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws SdfSDKException {
        return GMSSLRSASignUtils.signBySdf(SdfCryptoType.YUNHSM, algorithm, privateKeyIndex, privateKeyPassword, data);
    }

    public static String signByYunHsm(String algorithm, int privateKeyIndex, String privateKeyPassword, String data) throws SdfSDKException {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLRSASignUtils.signBySdf(SdfCryptoType.YUNHSM, algorithm, privateKeyIndex, privateKeyPassword, dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static byte[] signByPcie(String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws SdfSDKException {
        return GMSSLRSASignUtils.signBySdf(SdfCryptoType.PCIE, algorithm, privateKeyIndex, privateKeyPassword, data);
    }

    public static String signByPcie(String algorithm, int privateKeyIndex, String privateKeyPassword, String data) throws SdfSDKException {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] sign = GMSSLRSASignUtils.signBySdf(SdfCryptoType.PCIE, algorithm, privateKeyIndex, privateKeyPassword, dataBytes);
        return GMSSLByteArrayUtils.base64Encode((byte[])sign);
    }

    public static boolean verifyByYunHsm(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.YUNHSM, algorithm, publicKey, data, sign);
    }

    public static boolean verifyByYunHsm(String algorithm, PublicKey publicKey, String data, String sign) throws SdfSDKException {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.YUNHSM, algorithm, publicKey, dataBytes, signBytes);
    }

    public static boolean verifyByPcie(String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.PCIE, algorithm, publicKey, data, sign);
    }

    public static boolean verifyByPcie(String algorithm, PublicKey publicKey, String data, String sign) throws SdfSDKException {
        byte[] dataBytes = GMSSLByteArrayUtils.base64Decode((String)data);
        byte[] signBytes = GMSSLByteArrayUtils.base64Decode((String)sign);
        return GMSSLRSASignUtils.verifyBySdf(SdfCryptoType.PCIE, algorithm, publicKey, dataBytes, signBytes);
    }

    public static byte[] signBySdf(SdfCryptoType sdfCryptoType, String algorithm, int privateKeyIndex, String privateKeyPassword, byte[] data) throws SdfSDKException {
        AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
        SdfRSASigner sdfRSASigner = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(privateKeyIndex, privateKeyPassword);
        SdfRSAKeyParameters rsaKeyParameters = new SdfRSAKeyParameters(sdfPrivateKey);
        sdfRSASigner.init(true, (CipherParameters)rsaKeyParameters);
        sdfRSASigner.update(data, 0, data.length);
        byte[] sign = sdfRSASigner.generateSignature();
        sdfRSASigner.release();
        return sign;
    }

    public static boolean verifyBySdf(SdfCryptoType sdfCryptoType, String algorithm, PublicKey publicKey, byte[] data, byte[] sign) throws SdfSDKException {
        AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
        SdfRSASigner sdfRSASigner = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
        SdfRSAKeyParameters rsaKeyParameter = new SdfRSAKeyParameters((RSAPublicKey)publicKey);
        sdfRSASigner.init(false, (CipherParameters)rsaKeyParameter);
        sdfRSASigner.update(data, 0, data.length);
        boolean verify = sdfRSASigner.verifySignature(sign);
        sdfRSASigner.release();
        return verify;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

