package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.operator.utils.GMSSLXkfSignatureOutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.PublicKey;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/6/3 10:57
 **/
public class GMSSLSancContentVerifier implements ContentVerifier {
    private GMSSLSancSignatureOutputStream stream;
    private AlgorithmIdentifier algorithmIdentifier;

    public GMSSLSancContentVerifier(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        this.stream = new GMSSLSancSignatureOutputStream(publicKey,algorithmIdentifier);
        this.algorithmIdentifier = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return algorithmIdentifier;
    }

    @Override
    public OutputStream getOutputStream() {
        return stream;
    }

    @Override
    public boolean verify(byte[] expected) {
        try {
            return this.stream.verify(expected);
        } catch (Exception e) {
            throw new RuntimeOperatorException("exception obtaining verify: " + e.getMessage(), e);
        }
    }
}
