package com.xdja.pki.gmssl.crypto.utils.sanc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.*;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

import java.io.OutputStream;
import java.security.PublicKey;


/**
 * @description: 三未信安写入流工具类
 * @author: feng zhen
 * @date: 2020/6/3 10:37
 **/
public class GMSSLSancSignatureOutputStream extends OutputStream {
    private int index;
    private PublicKey publicKey;
    private byte[] data = new byte[0];
    private AlgorithmIdentifier algorithmIdentifier;
    private String signAlgName;

    GMSSLSancSignatureOutputStream(int index, String signAlgName) {
        this.signAlgName = signAlgName;
        this.index = index;
        this.algorithmIdentifier = GMSSLSignatureAlgorithm.convertAlgorithmIdentifier(signAlgName);
    }

    GMSSLSancSignatureOutputStream(PublicKey publicKey,AlgorithmIdentifier algorithmIdentifier) {
        this.publicKey = publicKey;
        this.algorithmIdentifier = algorithmIdentifier;
        this.signAlgName = GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithmIdentifier).getSigAlgName();
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(bytes, off, tmp, 0, len);
        data = GMSSLByteArrayUtils.mergeByteArray(data, tmp);
    }

    @Override
    public void write(byte[] bytes) {
        data = GMSSLByteArrayUtils.mergeByteArray(data, bytes);
    }

    @Override
    public void write(int var1) {
        byte[] tmp = new byte[1];
        tmp[0] = (byte) var1;
        data = GMSSLByteArrayUtils.mergeByteArray(data, tmp);
    }

    byte[] getSignature() throws Exception {
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.sign(new SdfPrivateKey(index), data, signAlgName);
        } else if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.sign(new SdfPrivateKey(index), data, signAlgName);
        } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLECSignUtils.sign(new SdfPrivateKey(index), data, null, signAlgName);
        } else {
            throw new SdfSDKException("sanc hsm  un support algorithmIdentifier: " + algorithmIdentifier.getAlgorithm().getId());
        }
    }

    boolean verify(byte[] expected) throws Exception {
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.verify(publicKey, data, expected, signAlgName);
        } else if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            return GMSSLRSASignUtils.verify(publicKey, data, expected, signAlgName);
        } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equalsIgnoreCase(algorithmIdentifier.getAlgorithm().getId())) {
            boolean verify = GMSSLECSignUtils.verify(publicKey, data, expected, null, signAlgName);
            System.out.println(verify);
            return verify;
        } else {
            throw new SdfSDKException("sanc hsm  un support algorithmIdentifier: " + algorithmIdentifier.getAlgorithm().getId());
        }
    }
}
