package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentOutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.PublicKey;

/**
 * @ClassName GMSSLXkfContentVerifier
 * @Description TODO
 * @Date 2020/5/21 19:22
 * @Author FengZhen
 */
public class GMSSLXkfContentVerifier implements ContentVerifier {
    private GMSSLXkfSignatureOutputStream stream;
    private AlgorithmIdentifier algorithmIdentifier;

    public GMSSLXkfContentVerifier(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        this.stream = new GMSSLXkfSignatureOutputStream(publicKey);
        this.algorithmIdentifier = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return algorithmIdentifier;
    }

    @Override
    public OutputStream getOutputStream() {
        return stream;
    }

    @Override
    public boolean verify(byte[] expected) {
        try {
            return this.stream.verify(expected);
        } catch (Exception e) {
            throw new RuntimeOperatorException("exception obtaining verify: " + e.getMessage(), e);
        }
    }
}
