package com.xdja.pki.gmssl.operator.utils;

import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.SignatureException;

/**
 * @ClassName GMSSLXkfSignatureOutputStream
 * @Description TODO
 * @Date 2020/5/21 19:18
 * @Author FengZhen
 */
public class GMSSLXkfSignatureOutputStream extends OutputStream {
    private int index;
    private String password;
    private PublicKey publicKey;
    private byte[] data = new byte[0];

    GMSSLXkfSignatureOutputStream(int index, String password) {
        this.index = index;
        this.password = password;
    }

    GMSSLXkfSignatureOutputStream(PublicKey publicKey) {
        this.publicKey = publicKey;
    }
    @Override
    public void write(byte[] bytes, int off, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(bytes, off, tmp, 0, len);
        data = GMSSLByteArrayUtils.mergeByteArray(data, tmp);
    }

    @Override
    public void write(byte[] bytes) {
        data = GMSSLByteArrayUtils.mergeByteArray(data, bytes);
    }

    @Override
    public void write(int var1) {
        byte[] tmp = new byte[1];
        tmp[0] = (byte) var1;
        data = GMSSLByteArrayUtils.mergeByteArray(data, tmp);
    }

    byte[] getSignature() throws Exception {
        return MiniPcieXKFUtils.sm2SignWithInternalHash(data,
                MiniPcieIndexEnum.getInfoFromIndex(index).getSignPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(index).getSignPrivateIndex(),
                password);
    }

    boolean verify(byte[] expected) throws Exception {
        try {
            return MiniPcieXKFUtils.sm2VerifyWithInternalHash(data, expected, new Sm2PublicKey(publicKey));
        } catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}
