package com.xdja.pki.gmssl.x509.utils;

import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;

import java.security.cert.X509Certificate;

public class GMSSLX500NameUtils {

    /**
     * 通过 X500 格式的 String DN 生成 X500Name
     * @param x500DN RFC4519 格式的 String DN CN=USER,O=XDJA,C=CN
     * @return X500Name
     */
    public static X500Name genX500NameWithBCStyle(String x500DN){
        return new X500Name(x500DN);
    }

    /**
     * 通过 RFC4519 格式的 String DN 生成 X500Name
     * @param rfc4519DN RFC4519 格式的 String DN CN=USER,O=XDJA,C=CN
     * @return X500Name
     */
    public static X500Name genX500NameWithRFC4519Style(String rfc4519DN){
        return new X500Name(RFC4519Style.INSTANCE, rfc4519DN);
    }

    /**
     * 通过 证书 获取 RFC 格式的 String Issuer DN 大写 关键字之间没有空格
     * @param certificate 证书 证书中存储的为 X500格式的DN 即 C=CN,O=XDJA,CN=USER
     * @return RFC 格式的 String DN CN=USER,O=XDJA,C=CN
     */
    public static String getRFCStyleIssuerDN(X509Certificate certificate){
        return certificate.getIssuerX500Principal().getName();
    }
    /**
     * 通过 证书 获取 RFC 格式的 String Subject DN 大写 关键字之间没有空格
     * @param certificate 证书 证书中存储的为 X500格式的DN 即 C=CN,O=XDJA,CN=USER
     * @return RFC 格式的 String DN CN=USER,O=XDJA,C=CN
     */
    public static String getRFCStyleSubjectDN(X509Certificate certificate){
        return certificate.getSubjectX500Principal().getName();
    }


}
