/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.init;

import com.xdja.SafeKey.utils.pool.MiniPcieConnectionPool;
import com.xdja.pki.gmssl.crypto.utils.sanc.GMSSLSancConnectionUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;

public class GMSSLPkiCryptoInit {
    private static GMSSLCryptoType cryptoType = GMSSLCryptoType.BC;
    private static int maxTotal = 100;

    private GMSSLPkiCryptoInit(GMSSLCryptoType cryptoType) {
        GMSSLPkiCryptoInit.cryptoType = cryptoType;
    }

    public static GMSSLCryptoType getCryptoType() {
        return cryptoType;
    }

    public static GMSSLCryptoType getSdfCryptoType() throws Exception {
        if (!cryptoType.checkSdfCryptoTypeSupport()) {
            throw new Exception("un support this crypto" + (Object)((Object)cryptoType));
        }
        return cryptoType;
    }

    public static void getBCInstance() {
        new GMSSLPkiCryptoInit(GMSSLCryptoType.BC);
    }

    public static void getXdjaYunHsmInstance() {
        HsmConnectionProviderImpl.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.XDJA_HSM);
    }

    public static void getPcieInstance() {
        PcieConnectionProviderImpl.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.PCI_E);
    }

    public static void getMiniPcieInstance() {
        MiniPcieConnectionPool.getInstance();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.MINI_PCI_E);
    }

    public static void getSancHsmInstance() throws Exception {
        GMSSLSancConnectionUtils.init();
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }

    public static void getSancHsmInstance(String configPath) throws Exception {
        GMSSLSancConnectionUtils.init(configPath);
        new GMSSLPkiCryptoInit(GMSSLCryptoType.SANC_HSM);
    }
}

