/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils.bean;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public final class GMSSLSignatureAlgorithm
extends Enum<GMSSLSignatureAlgorithm> {
    public static final /* enum */ GMSSLSignatureAlgorithm SM3_WITH_SM2 = new GMSSLSignatureAlgorithm(GMObjectIdentifiers.sm2sign_with_sm3, "SM3WITHSM2");
    public static final /* enum */ GMSSLSignatureAlgorithm SHA1_WITH_RSA = new GMSSLSignatureAlgorithm(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA");
    public static final /* enum */ GMSSLSignatureAlgorithm SHA1_WITH_ECDSA = new GMSSLSignatureAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA");
    public static final /* enum */ GMSSLSignatureAlgorithm SHA256_WITH_RSA = new GMSSLSignatureAlgorithm(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
    public static final /* enum */ GMSSLSignatureAlgorithm SHA512_WITH_RSA = new GMSSLSignatureAlgorithm(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
    public static final /* enum */ GMSSLSignatureAlgorithm SHA256_WITH_ECDSA = new GMSSLSignatureAlgorithm(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
    private ASN1ObjectIdentifier aid;
    private String sigAlgName;
    private static final /* synthetic */ GMSSLSignatureAlgorithm[] $VALUES;

    public static GMSSLSignatureAlgorithm[] values() {
        return (GMSSLSignatureAlgorithm[])$VALUES.clone();
    }

    public static GMSSLSignatureAlgorithm valueOf(String name) {
        return Enum.valueOf(GMSSLSignatureAlgorithm.class, name);
    }

    public ASN1ObjectIdentifier getAid() {
        return this.aid;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    private GMSSLSignatureAlgorithm(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public AlgorithmIdentifier convertAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlgName);
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(String algorithm) {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(String algorithm, boolean isWithSignParam) {
        GMSSLSignatureAlgorithm gmsslSignatureAlgorithm = GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithm);
        assert (gmsslSignatureAlgorithm != null);
        if (isWithSignParam) {
            return new AlgorithmIdentifier(gmsslSignatureAlgorithm.aid, (ASN1Encodable)DERNull.INSTANCE);
        }
        return new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        return GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(ASN1ObjectIdentifier aid) {
        if (aid.getId().equalsIgnoreCase(GMObjectIdentifiers.sm2sign_with_sm3.getId())) {
            return SM3_WITH_SM2;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return SHA1_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return SHA256_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId())) {
            return SHA512_WITH_RSA;
        }
        if (aid.getId().equalsIgnoreCase(X9ObjectIdentifiers.ecdsa_with_SHA256.getId())) {
            return SHA256_WITH_ECDSA;
        }
        if (aid.getId().equalsIgnoreCase(X9ObjectIdentifiers.ecdsa_with_SHA1.getId())) {
            return SHA1_WITH_ECDSA;
        }
        return null;
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(String sigAlgName) {
        if (sigAlgName.equalsIgnoreCase(SM3_WITH_SM2.getSigAlgName())) {
            return SM3_WITH_SM2;
        }
        if (sigAlgName.equalsIgnoreCase(SHA1_WITH_RSA.getSigAlgName())) {
            return SHA1_WITH_RSA;
        }
        if (sigAlgName.equalsIgnoreCase(SHA256_WITH_RSA.getSigAlgName())) {
            return SHA256_WITH_RSA;
        }
        if (sigAlgName.equalsIgnoreCase(SHA512_WITH_RSA.getSigAlgName())) {
            return SHA512_WITH_RSA;
        }
        if (sigAlgName.equalsIgnoreCase(SHA256_WITH_ECDSA.getSigAlgName())) {
            return SHA256_WITH_ECDSA;
        }
        if (sigAlgName.equalsIgnoreCase(SHA1_WITH_ECDSA.getSigAlgName())) {
            return SHA1_WITH_ECDSA;
        }
        return null;
    }

    static {
        $VALUES = new GMSSLSignatureAlgorithm[]{SM3_WITH_SM2, SHA1_WITH_RSA, SHA1_WITH_ECDSA, SHA256_WITH_RSA, SHA512_WITH_RSA, SHA256_WITH_ECDSA};
    }
}

