/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.util.Arrays;

public class GMSSLPKCS1Encodeing {
    private static final int HEADER_LENGTH = 10;

    private static int getEngineInputBlockSize(boolean forEncryption, int bitSize) {
        return forEncryption ? (bitSize + 7) / 8 - 1 : (bitSize + 7) / 8;
    }

    private static int getEngineOutputBlockSize(boolean forEncryption, int bitSize) {
        return forEncryption ? (bitSize + 7) / 8 : (bitSize + 7) / 8 - 1;
    }

    private static int getInputBlockSize(boolean forEncryption, int bitSize) {
        int baseBlockSize;
        int n = baseBlockSize = forEncryption ? (bitSize + 7) / 8 - 1 : (bitSize + 7) / 8;
        if (forEncryption) {
            return baseBlockSize - 10;
        }
        return baseBlockSize;
    }

    private static int getOutputBlockSize(boolean forEncryption, int bitSize) {
        int baseBlockSize;
        int n = baseBlockSize = forEncryption ? (bitSize + 7) / 8 : (bitSize + 7) / 8 - 1;
        if (forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 10;
    }

    public static byte[] encodeBlock(byte[] in, int inOff, int inLen, int keyBits) {
        if (inLen > GMSSLPKCS1Encodeing.getInputBlockSize(true, keyBits)) {
            throw new IllegalArgumentException("input data too large");
        }
        SecureRandom random = new SecureRandom();
        byte[] block = new byte[GMSSLPKCS1Encodeing.getEngineInputBlockSize(true, keyBits) + 1];
        random.nextBytes(block);
        block[0] = 0;
        block[1] = 2;
        for (int i = 2; i != block.length - inLen - 2; ++i) {
            while (block[i] == 0) {
                block[i] = (byte)random.nextInt();
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return block;
    }

    public static byte[] decodeBlock(byte[] block, int keyBits) throws InvalidCipherTextException {
        byte[] data = new byte[keyBits / 8 - 1];
        System.arraycopy(block, 1, data, 0, data.length);
        byte type = data[0];
        int start = GMSSLPKCS1Encodeing.findStart(type, data);
        if (++start < 10) {
            Arrays.fill((byte[])data, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        byte[] result = new byte[data.length - start];
        System.arraycopy(data, start, result, 0, result.length);
        return result;
    }

    public static byte[] encodePrivateBlock(byte[] in, int inOff, int inLen, int keyBits) {
        if (inLen > GMSSLPKCS1Encodeing.getInputBlockSize(true, keyBits)) {
            throw new IllegalArgumentException("input data too large");
        }
        SecureRandom random = new SecureRandom();
        byte[] block = new byte[GMSSLPKCS1Encodeing.getEngineInputBlockSize(true, keyBits) + 1];
        random.nextBytes(block);
        block[0] = 0;
        block[1] = 1;
        for (int i = 2; i != block.length - inLen - 1; ++i) {
            block[i] = -1;
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return block;
    }

    private static int findStart(byte type, byte[] block) {
        int start = -1;
        boolean padErr = false;
        for (int i = 1; i != block.length; ++i) {
            byte pad = block[i];
            if (pad == 0 & start < 0) {
                start = i;
            }
            padErr |= type == 1 & start < 0 & pad != -1;
        }
        if (padErr) {
            return -1;
        }
        return start;
    }
}

