package com.xdja.pki.gmssl.sdf.bean;

public enum SdfAlgIdHash {

    /*****************************
     * 密码杂凑算法标识
     *****************************/

    /**
     * SM3杂凑算法
     */
    SGD_SM3(0x00000001, "SGD_SM3"),

    /**
     * SHA_1杂凑算法
     */
    SGD_SHA1(0x00000002, "SGD_SHA1"),

    /**
     * SHA_256杂凑算法
     */
    SGD_SHA256(0x00000004, "SGD_SHA256");

    private int id;
    private String name;

    SdfAlgIdHash(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "SdfAlgIdSymmetric{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }
}
