package com.xdja.pki.gmssl.sdf.bean;

public enum SdfAlgIdSymmetric {

    /*****************************
     * 分组密码算法标识
     *****************************/

    /**
     * SM1算法ECB加密模式
     */
    SGD_SM1_ECB(0x00000101, "SGD_SM1_ECB"),

    /**
     * SM1算法CBC加密模式
     */
    SGD_SM1_CBC(0x00000102, "SGD_SM1_CBC"),

    /**
     * SM1算法CBC加密模式
     * 密码机 暂时不支持
     */
    SGD_SM1_MAC(0x00000110, "SGD_SM1_MAC"),

    /**
     * SM4算法ECB加密模式
     */
    SGD_SM4_ECB(0x00000401, "SGD_SM4_ECB"),

    /**
     * SM4算法CBC加密模式
     */
    SGD_SM4_CBC(0x00000402, "SGD_SM4_CBC"),

    /**
     * SM4算法MAC加密模式
     * 密码机 暂时不支持
     */
    SGD_SM4_MAC(0x00000410, "SGD_SM4_MAC");

    private int id;
    private String name;

    SdfAlgIdSymmetric(int id, String name){
        this.id = id;
        this.name = name;
    }

    public int getId(){
        return this.id;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "SdfAlgIdSymmetric{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }
}
