package com.xdja.pki.gmssl.sdf;

import com.xdja.pki.gmssl.sdf.bean.*;

import java.security.KeyPair;

public interface SdfSDK {

    void init() throws SdfSDKException;

    void release() throws SdfSDKException;

    byte[] generateRandom(int uiLength) throws SdfSDKException;

    SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException;

    SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException;

    boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException;

    SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException;

    SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException;

    void externalVerifyECC(SdfECCPublicKey key, byte[] data, SdfECCSignature pucSignature) throws SdfSDKException;

    void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException;

    SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException;

    SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException;

    SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data, String stdName) throws SdfSDKException;

    byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher pucEncData) throws SdfSDKException;

    byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException;

    /**
     * 生成ECC公钥加密的 会话密钥，返回加密会话密钥
     *
     * @param sdfECCPublicKey 加密的ECC公钥
     * @return ECC加密的会话密钥
     * @throws SdfSDKException 异常
     */
    SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    /**
     * 生成ECC公钥加密的 会话密钥，返回handle
     *
     * @param sdfECCPublicKey 加密的ECC公钥
     * @return 加密的会话密钥
     * @throws SdfSDKException 异常
     */
    long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    /**
     * 生成ECC公钥加密的 会话密钥，返回加密会话密钥及handle
     *
     * @param sdfECCPublicKey 加密ECC公钥
     * @return 加密的会话密钥 和 会话密钥所在handle
     * @throws SdfSDKException
     */
    SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException;

    /**
     * 导入ECC公钥加密的 会话密钥
     *
     * @param uiIskIndex   加密ECC公钥对应的私钥 索引
     * @param password     加密ECC公钥对应的私钥 访问控制码
     * @param sdfECCCipher ECC加密结构体
     * @return 会话密钥所在 handle
     * @throws SdfSDKException 异常
     */
    long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException;

    long[] importKey(byte[] pucKey) throws SdfSDKException;

    byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucData) throws SdfSDKException;

    byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] pucIv, byte[] pucEncData) throws SdfSDKException;

    void destroyKey(long[] phKeyHandle) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException;

    void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException;

    void hashUpdate(byte[] data) throws SdfSDKException;

    byte[] hashFinal(int digestLen) throws SdfSDKException;

    void calculateMac(int uiKeyIndex) throws SdfSDKException;

    byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException;

    SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException;

    SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException;

    SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException;

    byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException;

    byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException;

    /**
     * AEAD 加密 对称消息验证码认证加密
     *
     * @param phKeyHandle key 所在的密钥句柄
     * @param uiAlgId     算法标识
     * @param tagLen      消息验证码长度
     * @param nonce       nonce 特定数据
     * @param aad         aad 附加数据
     * @param data        明文数据 待加密数据
     * @return 输出 密文数据 + 校验码 ： cipher || tag
     */
    byte[] encryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException;

    /**
     * AEAD 解密 对称消息验证码认证解密
     *
     * @param phKeyHandle key 所在的密钥句柄
     * @param uiAlgId     算法标识
     * @param tagLen      消息验证码长度
     * @param nonce       nonce 特定数据
     * @param aad         aad 附加数据
     * @param enc         密文数据 待解密数据
     * @return 输出 明文数据 + 校验码 ： plaintext || tag
     */
    byte[] decryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException;

    /**
     * 导入 会话密钥 并用 密钥加密密钥 解密
     *
     * @param uiAlgId    算法标识 加密模式使用ECB模式
     * @param uiKekIndex 密钥加密密钥索引值
     * @param pucKey     会话密钥密文
     * @return 会话密钥句柄
     */
    long[] importKeyWithKek(SdfAlgIdSymmetric uiAlgId, int uiKekIndex, byte[] pucKey) throws SdfSDKException;


    /**
     * 生成会话密钥并用 RSA公钥 加密输出，不返回handle
     *
     * @param sdfRSAPublicKey 加密的RSA公钥
     * @return RSA加密的会话密钥
     * @throws SdfSDKException 异常
     */
    byte[] generateKeyWithEpkRsa(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException;

    /**
     * 生成会话密钥并用 RSA公钥 加密输出，返回handle
     *
     * @param sdfRSAPublicKey 加密的RSA公钥
     * @return 加密的会话密钥
     * @throws SdfSDKException 异常
     */
    long[] generateKeyWithEpkRsaHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException;

    /**
     * 生成RSA公钥加密的 会话密钥，返回加密会话密钥及handle
     *
     * @param sdfRSAPublicKey 加密RSA公钥
     * @return 加密的会话密钥 和 会话密钥所在handle
     * @throws SdfSDKException
     */
    SdfSymmetricKeyHandle generateKeyWithEpkRsaKeyHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException;

    /**
     * 导入RSA公钥加密的 会话密钥
     *
     * @param uiIskIndex 加密RSA公钥对应的私钥 索引
     * @param password   加密RSA公钥对应的私钥 访问控制码
     * @param pucKey     加密的会话密钥
     * @return 会话密钥所在 handle
     * @throws SdfSDKException 异常
     */
    long[] importKeyWithIskRsa(int uiIskIndex, byte[] password, byte[] pucKey) throws SdfSDKException;

    /**
     * 生成Kek
     *
     * @param uiAlgId    kek加密方式
     * @param uiKekIndex kek对应的密钥索引
     * @return kek密文
     */
    byte[] generateKeyWithKek(int uiAlgId, int uiKekIndex) throws SdfSDKException;

}
