/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.bean;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public enum SdfAlgIdHash {
    SGD_SM3(1, "SGD_SM3", 32),
    SGD_SHA1(2, "SGD_SHA1", 20),
    SGD_SHA256(4, "SGD_SHA256", 32),
    SGD_SHA384(17, "SGD_SHA384", 48),
    SGD_SHA512(18, "SGD_SHA512", 64);

    private int id;
    private String name;
    private int digestLength;

    private SdfAlgIdHash(int id, String name, int digestLength) {
        this.id = id;
        this.name = name;
        this.digestLength = digestLength;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    public String toString() {
        return "SdfAlgIdSymmetric{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }

    public static SdfAlgIdHash converSdfAlgIdHash(ASN1ObjectIdentifier aid) {
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SGD_SHA1;
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SGD_SHA256;
        }
        return null;
    }

    public static SdfAlgIdHash convertSdfAlgIdHash(String algorithm) {
        if ("SHA1".equalsIgnoreCase(algorithm)) {
            return SGD_SHA1;
        }
        if ("SHA256".equalsIgnoreCase(algorithm)) {
            return SGD_SHA256;
        }
        return null;
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(SdfAlgIdHash sdfAlgIdHash) {
        if (sdfAlgIdHash == SGD_SHA1) {
            return new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, (ASN1Encodable)DERNull.INSTANCE);
        }
        if (sdfAlgIdHash == SGD_SHA256) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        }
        return null;
    }
}

