/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class SdfECCPublicKey {
    private byte[] x;
    private byte[] y;

    public static SdfECCPublicKey getInstance(ECPublicKey ecPublicKey) {
        int ecPublicKeyBits = GMSSLX509Utils.getECPublicKeyBits((ECPublicKey)ecPublicKey);
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineX(), (int)(ecPublicKeyBits / 8)), GMSSLByteArrayUtils.asUnsignedByteArray((BigInteger)ecPublicKey.getW().getAffineY(), (int)(ecPublicKeyBits / 8)));
    }

    public static SdfECCPublicKey getInstance(BigInteger x, BigInteger y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)x), GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)y));
    }

    public static SdfECCPublicKey getInstanceFilterHead(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])x), GMSSLByteArrayUtils.filterByteArrayZeroInHead((byte[])y));
    }

    public static SdfECCPublicKey getInstanceFilterFoot(byte[] x, byte[] y) {
        return new SdfECCPublicKey(GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])x), GMSSLByteArrayUtils.filterByteArrayZeroInFoot((byte[])y));
    }

    public SdfECCPublicKey(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    public String toString() {
        return "SdfECCPublicKey{x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + '}';
    }
}

