package com.xdja.pki.gmssl.sdf.bean;

public enum SdfAlgIdAsymmetric {

    /*****************************
     * 非对称密钥算法标识
     *****************************/

    /**
     * RSA算法
     */
    SGD_RSA(0x00010000, "SGD_RSA"),

    /**
     * SM2椭圆曲线密码算法
     */
    SGD_SM2(0x00020100, "SGD_SM2"),

    /**
     * SM2椭圆曲线签名算法
     */
    SGD_SM2_1(0x00020200, "SGD_SM2_1"),

    /**
     * SM2椭圆曲线密钥交换协议
     */
    SGD_SM2_2(0x00020400, "SGD_SM2_2"),

    /**
     * SM2椭圆曲线加密算法
     */
    SGD_SM2_3(0x00020800, "SGD_SM2_3"),

    /**
     * ECC-NISTP256椭圆曲线密码算法
     */
    SGD_ECC_NISTP256(0x00040100, "SGD_ECC_NISTP256"),

    /**
     * ECC-NISTP384椭圆曲线密码算法
     */
    SGD_ECC_NISTP384(0x00040200, "SGD_ECC_NISTP384"),

    /**
     * ECC-NISTP521椭圆曲线密码算法
     */
    SGD_ECC_NISTP521(0x00040400, "SGD_ECC_NISTP521");

    private int id;
    private String name;

    SdfAlgIdAsymmetric(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return "SdfAlgIdSymmetric{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }
}
