package com.xdja.pki.gmssl.sdf.bean;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public enum SdfAlgIdHash {

    /*****************************
     * 密码杂凑算法标识
     *****************************/

    /**
     * SM3杂凑算法
     */
    SGD_SM3(0x00000001, "SGD_SM3", 32),

    /**
     * SHA_1杂凑算法
     */
    SGD_SHA1(0x00000002, "SGD_SHA1", 20),

    /**
     * SHA_256杂凑算法
     */
    SGD_SHA256(0x00000004, "SGD_SHA256", 32),

    /**
     * SGD_SHA384杂凑算法
     */
    SGD_SHA384(0x00000011, "SGD_SHA384", 48),


    /**
     * SGD_SHA512杂凑算法
     */
    SGD_SHA512(0x00000012, "SGD_SHA512", 64);


    private int id;
    private String name;
    private int digestLength;

    SdfAlgIdHash(int id, String name, int digestLength) {
        this.id = id;
        this.name = name;
        this.digestLength = digestLength;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return name;
    }

    public int getDigestLength() {
        return digestLength;
    }

    @Override
    public String toString() {
        return "SdfAlgIdSymmetric{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }

    public static SdfAlgIdHash converSdfAlgIdHash(ASN1ObjectIdentifier aid) {
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SdfAlgIdHash.SGD_SHA1;
        } else if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SdfAlgIdHash.SGD_SHA256;
        } else {
            return null;
        }
    }

    public static SdfAlgIdHash convertSdfAlgIdHash(String algorithm) {
        if ("SHA1".equalsIgnoreCase(algorithm)) {
            return SGD_SHA1;
        } else if ("SHA256".equalsIgnoreCase(algorithm)) {
            return SGD_SHA256;
        } else {
            return null;
        }
    }

    public static AlgorithmIdentifier convertAlgorithmIdentifier(SdfAlgIdHash sdfAlgIdHash) {
        if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA1) {
            return new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, DERNull.INSTANCE);
        } else if (sdfAlgIdHash == SdfAlgIdHash.SGD_SHA256) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        } else {
            return null;
        }
    }
}
