package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class SdfECCPublicKey {
    private byte[] x;
    private byte[] y;

    public static SdfECCPublicKey getInstance(ECPublicKey ecPublicKey) {
        int ecPublicKeyBits = GMSSLX509Utils.getECPublicKeyBits(ecPublicKey);
        return new SdfECCPublicKey(
                GMSSLByteArrayUtils.asUnsignedByteArray(ecPublicKey.getW().getAffineX(), ecPublicKeyBits / 8),
                GMSSLByteArrayUtils.asUnsignedByteArray(ecPublicKey.getW().getAffineY(), ecPublicKeyBits / 8)
        );
    }

    public static SdfECCPublicKey getInstance(BigInteger x, BigInteger y) {
        return new SdfECCPublicKey(
                GMSSLByteArrayUtils.asUnsignedByteArray32(x),
                GMSSLByteArrayUtils.asUnsignedByteArray32(y)
        );
    }

    public static SdfECCPublicKey getInstanceFilterHead(byte[] x, byte[] y) {
        return new SdfECCPublicKey(
                GMSSLByteArrayUtils.filterByteArrayZeroInHead(x),
                GMSSLByteArrayUtils.filterByteArrayZeroInHead(y)
        );
    }


    public static SdfECCPublicKey getInstanceFilterFoot(byte[] x, byte[] y) {
        return new SdfECCPublicKey(
                GMSSLByteArrayUtils.filterByteArrayZeroInFoot(x),
                GMSSLByteArrayUtils.filterByteArrayZeroInFoot(y)
        );
    }

    public SdfECCPublicKey(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }


    public byte[] getX() {
        return x;
    }

    public void setX(byte[] x) {
        this.x = x;
    }

    public byte[] getY() {
        return y;
    }

    public void setY(byte[] y) {
        this.y = y;
    }

    @Override
    public String toString() {
        return "SdfECCPublicKey{" +
                "x=" + Arrays.toString(x) +
                ", y=" + Arrays.toString(y) +
                '}';
    }
}
