package com.xdja.pki.gmssl.sdf.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.util.BigIntegers;

import java.util.Arrays;

/**
 * @ClassName SdfRSAPrivateKey
 * @Date 2019/8/30 9:13
 * @Author FengZhen
 */
public class SdfRSAPrivateKey {
    /**
     * 模长
     */
    private int bits;
    /**
     * 模N
     */
    private byte[] m ;
    /**
     * 公钥指数
     */
    private byte[] e ;
    /**
     * 私钥指数
     */
    private byte[] d ;
    /**
     * 素数P和q
     */
    private byte[][] prime ;
    /**
     * Dp和Dq
     */
    private byte[][] pexp ;
    /**
     * 系数i
     */
    private byte[] coef ;

    public SdfRSAPrivateKey() {
        super();
    }

    public SdfRSAPrivateKey(int bits, byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) {
        super();
        this.bits = bits;
        this.m = m;
        this.e = e;
        this.d = d;
        this.prime = prime;
        this.pexp = pexp;
        this.coef = coef;
    }

    public static SdfRSAPrivateKey getInstance(BCRSAPrivateCrtKey privateCrtKey) {
        byte[][] prime = new byte[2][];
        prime[0] = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPrimeP()), 128);
        prime[1] = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPrimeQ()), 128);
        byte[][] pexp = new byte[2][];
        pexp[0] =GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPrimeExponentP()), 128);
        pexp[1] = GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPrimeExponentQ()), 128);
        int bitLength = privateCrtKey.getModulus().bitLength();
        return new SdfRSAPrivateKey(
                bitLength,
                GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getModulus()), 256),
                GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPublicExponent()), 256),
                GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getPrivateExponent()), 256),
                prime,
                pexp,
                GMSSLByteArrayUtils.changeByteArrayLength(BigIntegers.asUnsignedByteArray(privateCrtKey.getCrtCoefficient()), 128)
        );
    }

    public int getBits() {
        return bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    public byte[] getD() {
        return d;
    }

    public void setD(byte[] d) {
        this.d = d;
    }

    public byte[][] getPrime() {
        return prime;
    }

    public void setPrime(byte[][] prime) {
        this.prime = prime;
    }

    public byte[][] getPexp() {
        return pexp;
    }

    public void setPexp(byte[][] pexp) {
        this.pexp = pexp;
    }

    public byte[] getCoef() {
        return coef;
    }

    public void setCoef(byte[] coef) {
        this.coef = coef;
    }

    @Override
    public String toString() {
        return "SdfRSAPrivateKey{" +
                "bits=" + bits +
                ", m=" + Arrays.toString(m) +
                ", e=" + Arrays.toString(e) +
                ", d=" + Arrays.toString(d) +
                ", prime=" + Arrays.toString(prime) +
                ", pexp=" + Arrays.toString(pexp) +
                ", coef=" + Arrays.toString(coef) +
                '}';
    }
}
