package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.SecureRandom;

public class SdfRandom extends SecureRandom {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SdfSDK sdfSDK;

    public SdfRandom() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfRandom(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfRandom(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    public byte[] generateRandom(int len) throws SdfSDKException {
        return sdfSDK.generateRandom(len);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        try {
            byte[] out = sdfSDK.generateRandom(bytes.length);
            System.arraycopy(out, 0, bytes, 0, bytes.length);
        } catch (SdfSDKException e) {
            logger.error("sdfSDK generateRandom " + bytes.length, e);
        }
    }

    public void release() throws SdfSDKException {
        if (sdfSDK != null) {
            sdfSDK.release();
        }
    }
}
