/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRSASigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.crypto.sdf.SdfSigner;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SignatureException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.RuntimeOperatorException;

public class SdfContentOutputStream
extends OutputStream {
    private SdfSigner signer;
    private ByteArrayOutputStream outputStream;
    private Exception exception;

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, boolean forSigning, AsymmetricKeyParameter asymmetricKeyParameter) {
        this(sdfCryptoType, algorithmIdentifier, forSigning, asymmetricKeyParameter, false);
    }

    SdfContentOutputStream(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, boolean forSigning, AsymmetricKeyParameter asymmetricKeyParameter, boolean useBC) {
        try {
            if (SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm())) {
                this.signer = new SdfRSASigner(sdfCryptoType, algorithmIdentifier);
            } else if (GMObjectIdentifiers.sm2sign_with_sm3.getId().equals(algorithmIdentifier.getAlgorithm().getId())) {
                this.signer = useBC ? new SdfSM2SignerSM3(sdfCryptoType) : new SdfSM2Signer(sdfCryptoType);
            } else {
                throw new SdfSDKException("UnSupport algorithmIdentifier: " + algorithmIdentifier.getAlgorithm().getId());
            }
            this.signer.init(forSigning, (CipherParameters)asymmetricKeyParameter);
            this.outputStream = new ByteArrayOutputStream();
        }
        catch (SdfSDKException e) {
            throw new RuntimeOperatorException("exception obtaining signature init : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.outputStream.write(bytes, off, len);
    }

    @Override
    public void write(byte[] bytes) {
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    @Override
    public void write(int b) {
        this.outputStream.write((byte)b);
    }

    byte[] getSignature() throws SignatureException {
        this.updateData();
        try {
            byte[] signature = this.signer.generateSignature();
            this.signer.release();
            return signature;
        }
        catch (SdfSDKException | CryptoException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

    boolean verify(byte[] expected) throws SignatureException {
        this.updateData();
        try {
            boolean verify = this.signer.verifySignature(expected);
            this.signer.release();
            return verify;
        }
        catch (SdfSDKException e) {
            throw new SignatureException("exception obtaining signature: " + e.getMessage(), e);
        }
    }

    void updateData() throws SignatureException {
        if (this.exception != null) {
            throw new SignatureException("write signature exception: " + this.exception.getMessage(), this.exception);
        }
        byte[] data = this.outputStream.toByteArray();
        this.signer.update(data, 0, data.length);
    }
}

