/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfBaseDigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import org.bouncycastle.util.Memoable;

public class SdfSHADigest
extends SdfBaseDigest {
    private static final int SHA1_DIGEST_LENGTH = 20;
    private static final int SHA256_DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;
    private SdfAlgIdHash sdfAlgIdHash;

    public SdfSHADigest(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);
    }

    public SdfSHADigest(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfAlgIdHash);
    }

    public SdfSHADigest(SdfSDK sdfSDK, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
        this.sdfAlgIdHash = sdfAlgIdHash;
    }

    public SdfSHADigest(SdfSHADigest t) throws SdfSDKException {
        this.copyIn(t);
    }

    private void init() throws SdfSDKException {
        this.sdfSDK.hashInit(this.sdfAlgIdHash);
        this.isInit = true;
    }

    @Override
    protected void checkInit() throws SdfSDKException {
        if (!this.isInit) {
            this.init();
        }
    }

    private void copyIn(SdfSHADigest t) throws SdfSDKException {
        this.sdfSDK = SdfCryptoType.cloneSdfSDK(t.sdfSDK);
        this.sdfSDK.init();
        this.checkInit();
        if (t.in != null) {
            this.update(t.in, 0, t.in.length);
        }
    }

    public String getAlgorithmName() {
        return this.sdfAlgIdHash.getName();
    }

    public int getDigestSize() {
        return this.sdfAlgIdHash.getId() == SdfAlgIdHash.SGD_SHA1.getId() ? 20 : 32;
    }

    public int getByteLength() {
        return 64;
    }

    public Memoable copy() {
        try {
            return new SdfSHADigest(this);
        }
        catch (SdfSDKException e) {
            this.logger.error("Memoable copy", (Throwable)e);
            return null;
        }
    }

    public void reset(Memoable other) {
        SdfSHADigest d = (SdfSHADigest)other;
        try {
            this.copyIn(d);
        }
        catch (SdfSDKException e) {
            this.logger.error("reset copy in error", (Throwable)e);
        }
    }
}

