/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import java.security.PublicKey;

public class SdfSM2Key {
    private SdfSDK sdfSDK;

    public SdfSM2Key() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfSM2Key(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.sdfSDK.init();
    }

    public PublicKey exportSignPublicKey(int index) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = this.sdfSDK.exportSignPublicKeyEcc(index);
        try {
            return GMSSLX509Utils.convertSM2PublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY());
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public PublicKey exportEncryptPublicKey(int index) throws SdfSDKException {
        SdfECCPublicKey sdfECCPublicKey = this.sdfSDK.exportEncPublicKeyEcc(index);
        try {
            return GMSSLX509Utils.convertSM2PublicKey((byte[])sdfECCPublicKey.getX(), (byte[])sdfECCPublicKey.getY());
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }
}

