/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfBaseDigest;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdfSM3Digest
extends SdfBaseDigest {
    private Logger logger = LoggerFactory.getLogger((String)(this.getClass().getName() + "[" + this.getClass().hashCode() + "]"));
    private static final int DIGEST_LENGTH = 32;
    private static final int BYTE_LENGTH = 64;
    private SdfECCPublicKey publicKey;

    public SdfSM3Digest() throws SdfSDKException {
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType);
    }

    public SdfSM3Digest(SdfSDK sdfSDK) throws SdfSDKException {
        super(sdfSDK);
    }

    public SdfSM3Digest(SdfSDK sdfSDK, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
        this.pucID = pucID;
        this.publicKey = publicKey;
    }

    public SdfSM3Digest(SdfCryptoType sdfCryptoType, byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.sdfSDK.init();
        this.pucID = pucID;
        this.publicKey = publicKey;
    }

    public SdfSM3Digest(SdfSM3Digest t) throws SdfSDKException {
        this.copyIn(t);
    }

    private void init() throws SdfSDKException {
        this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        this.isInit = true;
    }

    private void init(byte[] pucID, SdfECCPublicKey publicKey) throws SdfSDKException {
        this.pucID = pucID;
        this.publicKey = publicKey;
        this.sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3, pucID, publicKey);
        this.isInit = true;
    }

    @Override
    protected void checkInit() throws SdfSDKException {
        if (!this.isInit) {
            if (this.publicKey != null && this.pucID != null) {
                this.init(this.pucID, this.publicKey);
            } else {
                this.init();
            }
        }
    }

    private void copyIn(SdfSM3Digest t) throws SdfSDKException {
        this.sdfSDK = SdfCryptoType.cloneSdfSDK(t.sdfSDK);
        this.sdfSDK.init();
        this.publicKey = t.publicKey;
        this.pucID = t.pucID;
        this.checkInit();
        if (t.in != null) {
            this.update(t.in, 0, t.in.length);
        }
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public int getByteLength() {
        return 64;
    }

    public Memoable copy() {
        try {
            return new SdfSM3Digest(this);
        }
        catch (SdfSDKException e) {
            this.logger.error("Memoable copy", (Throwable)e);
            return null;
        }
    }

    public void reset(Memoable other) {
        SdfSM3Digest d = (SdfSM3Digest)other;
        try {
            this.copyIn(d);
            d.releaseConnection();
        }
        catch (SdfSDKException e) {
            this.logger.error("reset copy in error", (Throwable)e);
        }
    }
}

