/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdfBaseDigest
implements ExtendedDigest,
Memoable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SdfSDK sdfSDK;
    byte[] pucID;
    protected byte[] in = new byte[0];
    volatile boolean isInit = false;

    public SdfBaseDigest() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfBaseDigest(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK());
    }

    public SdfBaseDigest(SdfSDK sdfSDK) throws SdfSDKException {
        this.sdfSDK = sdfSDK;
        this.sdfSDK.init();
    }

    protected abstract void checkInit() throws SdfSDKException;

    public void update(byte in) {
        byte[] data = new byte[]{in};
        this.update(data, 0, data.length);
    }

    public void update(byte[] in, int inOff, int len) {
        byte[] data = new byte[len];
        System.arraycopy(in, inOff, data, 0, len);
        byte[] out = new byte[this.in.length + len];
        System.arraycopy(this.in, 0, out, 0, this.in.length);
        System.arraycopy(data, 0, out, this.in.length, len);
        this.in = out;
        try {
            this.checkInit();
            while (len > 4096) {
                byte[] m = new byte[4096];
                System.arraycopy(data, 0, m, 0, m.length);
                this.sdfSDK.hashUpdate(m);
                len -= 4096;
                byte[] dataNow = new byte[data.length - m.length];
                System.arraycopy(data, m.length, dataNow, 0, data.length - m.length);
                data = dataNow;
            }
            this.sdfSDK.hashUpdate(data);
        }
        catch (SdfSDKException e) {
            if (in.length != 0 || len == 0) {
                this.logger.info("update in.length={} len={}", new Object[]{in.length, len, e.getMessage()});
            }
            this.logger.error("update error in.length={} len={}", new Object[]{in.length, len, e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] out, int outOff) {
        int length = this.getDigestSize();
        try {
            byte[] res = this.sdfSDK.hashFinal(length);
            System.arraycopy(res, 0, out, outOff, res.length);
        }
        catch (SdfSDKException e) {
            this.logger.error("doFinal", (Throwable)e);
        }
        finally {
            this.isInit = false;
        }
        return length;
    }

    public void reset() {
        try {
            byte[] resBuf = new byte[this.getDigestSize()];
            if (this.isInit) {
                this.doFinal(resBuf, 0);
            }
            this.checkInit();
        }
        catch (SdfSDKException e) {
            this.logger.error("reset error", (Throwable)e);
        }
    }

    public void releaseConnection() {
        if (this.sdfSDK instanceof YunhsmSdfSDK) {
            ((YunhsmSdfSDK)this.sdfSDK).releaseConnection();
        }
    }

    public void release() throws SdfSDKException {
        if (this.sdfSDK != null) {
            this.sdfSDK.release();
        }
    }
}

