/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import java.security.PublicKey;

public class SdfRSAKey {
    private SdfSDK sdfSDK;

    public SdfRSAKey() throws SdfSDKException {
        this(SdfCryptoType.YUNHSM);
    }

    public SdfRSAKey(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        this.sdfSDK = sdfCryptoType.getSdfSDK();
        this.sdfSDK.init();
    }

    public PublicKey exportSignPublicKey(int index) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = this.sdfSDK.exportSignPublicKeyRsa(index);
        try {
            return GMSSLRSAUtils.convertRSAPublicKey((byte[])sdfRSAPublicKey.getM(), (byte[])sdfRSAPublicKey.getE());
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public PublicKey exportEncryptPublicKey(int index) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = this.sdfSDK.exportEncPublicKeyRsa(index);
        try {
            return GMSSLRSAUtils.convertRSAPublicKey((byte[])sdfRSAPublicKey.getM(), (byte[])sdfRSAPublicKey.getE());
        }
        catch (Exception e) {
            throw new SdfSDKException((Throwable)e);
        }
    }

    public void release() throws SdfSDKException {
        this.sdfSDK.release();
    }
}

