package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

public class SdfContentVerifierProvider implements ContentVerifierProvider {


    private SdfCryptoType sdfCryptoType;
    private PublicKey publicKey;
    private boolean useBC;
    private int bits = 256;

    public SdfContentVerifierProvider(SdfCryptoType sdfCryptoType, PublicKey publicKey) {
        this(sdfCryptoType, publicKey, 256);
    }

    public SdfContentVerifierProvider(SdfCryptoType sdfCryptoType, PublicKey publicKey, int bits) {
        this(sdfCryptoType, publicKey, Constants.SDF_SM2_USED_BC_SM3, bits);
    }

    public SdfContentVerifierProvider(SdfCryptoType sdfCryptoType, PublicKey publicKey, boolean useBC) {
        this(sdfCryptoType, publicKey, useBC, 256);
    }

    public SdfContentVerifierProvider(SdfCryptoType sdfCryptoType, PublicKey publicKey, boolean useBC, int bits) {
        this.sdfCryptoType = sdfCryptoType;
        this.publicKey = publicKey;
        this.useBC = useBC;
        this.bits = bits;
    }

    @Override
    public boolean hasAssociatedCertificate() {
        return false;
    }

    @Override
    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    @Override
    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        try {
            return new SdfContentVerifier(sdfCryptoType, verifierAlgorithmIdentifier, publicKey, useBC, bits);
        } catch (SdfSDKException e) {
            throw new OperatorCreationException(e.getMessage());
        }
    }
}
