package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;

public class SdfECSigner extends SdfECBaseSigner {

    public SdfECSigner() throws SdfSDKException {
        super();
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK());
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
    }

    public SdfECSigner(SdfCryptoType sdfCryptoType, String signAlgName, int bits) throws SdfSDKException {
        super(sdfCryptoType.getSdfSDK(), signAlgName);
        this.bits = bits;
    }


    @Override
    public void initDigest(byte[] userID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        digest = new SdfSM3Digest(sdfSDK, userID, sdfECCPublicKey);
    }

    @Override
    public void initDigest(String signAlgName) throws SdfSDKException {
        switch (signAlgName.toUpperCase()) {
            case Constants.SHA1_WITH_ECDSA:
                digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA1);
                break;
            case Constants.SHA256_WITH_ECDSA:
                digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA256);
                break;
            case Constants.SHA384_WITH_ECDSA:
                // TODO: 2021/6/30 增加384和512
                digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA384);
                break;
            case Constants.SHA512_WITH_ECDSA:
                digest = new SdfSHADigest(sdfSDK, SdfAlgIdHash.SGD_SHA512);
                break;
            default:
                throw new SdfSDKException("unSupport signAlg " + signAlgName);
        }
    }
}
