package com.xdja.pki.gmssl.crypto.sdf;

/**
 * @author sxy
 * @description
 * @date 2019年11月19日 21:50
 **/
public class Constants {
    /**
     * 是否使用软SM3
     */
    public static final boolean SDF_SM2_USED_BC_SM3 = false;
    /*************************************************************
     *                                                           *
     *                       曲线名称                             *
     * ***********************************************************/

    /**
     * SM2曲线
     */
    public static final String SM2_P_256 = "sm2p256v1";
    /**
     * NISTP256
     */
    public static final String NIST_P_256 = "P-256";
    /**
     * NISTP384
     */
    public static final String NIST_P_384 = "P-384";
    /**
     * NISTP521
     */
    public static final String NIST_P_521 = "P-521";

    /*************************************************************
     *                                                           *
     *                       签名算法                             *
     * ***********************************************************/

    /**
     * SM3_WITH_SM2
     */
    public static final String SM3_WITH_SM2 = "SM3WITHSM2";

    /**
     * SHA1_WITH_RSA
     */
    public static final String SHA1_WITH_RSA = "SHA1WITHRSA";


    /**
     * SHA256_WITH_RSA
     */
    public static final String SHA256_WITH_RSA = "SHA256WITHRSA";


    /**
     * SHA512_WITH_RSA
     */
    public static final String SHA512_WITH_RSA = "SHA512WITHRSA";


    /**
     * SHA1_WITH_ECDSA
     */
    public static final String SHA1_WITH_ECDSA = "SHA1WITHECDSA";

    /**
     * SHA256_WITH_ECDSA
     */
    public static final String SHA256_WITH_ECDSA = "SHA256WITHECDSA";


    /**
     * SHA384_WITH_ECDSA
     */
    public static final String SHA384_WITH_ECDSA = "SHA384WITHECDSA";


    /**
     * SHA512_WITH_ECDSA
     */
    public static final String SHA512_WITH_ECDSA = "SHA512WITHECDSA";

    /*************************************************************
     *                                                           *
     *                       密钥长度                             *
     * ***********************************************************/
    /**
     * 密钥长度256
     */
    public static final int KEY_BITS_256 = 256;
    /**
     * 密钥长度384
     */
    public static final int KEY_BITS_384 = 384;
    /**
     * 密钥长度521
     */
    public static final int KEY_BITS_521 = 521;
    /**
     * 密钥长度1024
     */
    public static final int KEY_BITS_1024 = 1024;
    /**
     * 密钥长度2048
     */
    public static final int KEY_BITS_2048 = 2048;

}
