package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.RuntimeOperatorException;

import java.io.OutputStream;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class SdfContentSigner implements ContentSigner {

    private SdfContentOutputStream stream;
    private AlgorithmIdentifier algorithmIdentifier;

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, Constants.SDF_SM2_USED_BC_SM3);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, int bits) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, Constants.SDF_SM2_USED_BC_SM3, bits);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, boolean useBC) throws SdfSDKException {
        this(sdfCryptoType, algorithmIdentifier, privateKey, useBC, 256);
    }

    public SdfContentSigner(SdfCryptoType sdfCryptoType, AlgorithmIdentifier algorithmIdentifier, SdfPrivateKey privateKey, boolean useBC, int bits) throws SdfSDKException {
        this.algorithmIdentifier = algorithmIdentifier;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (SdfSHAType.checkSupportType(algorithmIdentifier.getAlgorithm())) {
            asymmetricKeyParameter = new SdfRSAKeyParameters(privateKey);
        } else {
            asymmetricKeyParameter = new SdfECKeyParameters(privateKey);
        }
        this.stream = new SdfContentOutputStream(sdfCryptoType, algorithmIdentifier, true, asymmetricKeyParameter, useBC, bits);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        } catch (SignatureException e) {
            throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
        }
    }
}
