package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Memoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class SdfSHADigest extends SdfBaseDigest {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final int BYTE_LENGTH = 64;

    private SdfAlgIdHash sdfAlgIdHash;

    public SdfSHADigest(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(SdfCryptoType.YUNHSM, sdfAlgIdHash);

    }

    public SdfSHADigest(SdfCryptoType sdfCryptoType, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        this(sdfCryptoType.getSdfSDK(), sdfAlgIdHash);
    }

    public SdfSHADigest(SdfSDK sdfSDK, SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        super(sdfSDK);
        this.sdfAlgIdHash = sdfAlgIdHash;
    }

    public SdfSHADigest(SdfSHADigest t) throws SdfSDKException {
        copyIn(t);
    }

    @Override
    protected void init() throws SdfSDKException {
        this.sdfSDK.hashInit(this.sdfAlgIdHash);
    }

    @Override
    public String getAlgorithmName() {
        return this.sdfAlgIdHash.getName();
    }

    @Override
    public int getDigestSize() {
        return sdfAlgIdHash.getDigestLength();
    }

    @Override
    public int getByteLength() {
        return BYTE_LENGTH;
    }

    @Override
    public Memoable copy() {
        try {
            return new SdfSHADigest(this);
        } catch (SdfSDKException e) {
            logger.error("Memoable copy", e);
            return null;
        }
    }

    @Override
    public void reset(Memoable other) {
        SdfSHADigest d = (SdfSHADigest) other;
        try {
            copyIn(d);
            d.releaseConnection();
        } catch (SdfSDKException e) {
            logger.error("reset copy in error", e);
        }
    }
}
