package com.xdja.pki.gmssl.crypto.sdf;


import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

/**
 * @ClassName SdfSHAType
 * @Date 2019/9/12 15:06
 * @Author FengZhen
 */
public enum SdfSHAType {
    // sha1 rsa
    SHA1_WITH_RSA(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA"),
    // sha256 rsa
    SHA256_WITH_RSA(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA"),
    SHA384_WITH_RSA(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA"),
    SHA512_WITH_RSA(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");


    private ASN1ObjectIdentifier aid;

    private String sigAlgName;

    SdfSHAType(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public ASN1ObjectIdentifier getAid() {
        return aid;
    }

    public String getSigAlgName() {
        return sigAlgName;
    }

    public static SdfSHAType convertSdfSHAType(ASN1ObjectIdentifier aid) {
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SHA1_WITH_RSA;
        } else if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SHA256_WITH_RSA;
        } else if (PKCSObjectIdentifiers.sha384WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SHA384_WITH_RSA;
        } else if (PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equalsIgnoreCase(aid.getId())) {
            return SHA512_WITH_RSA;
        } else {
            return null;
        }
    }

    public static SdfSHAType convertSdfSHAType(String algorithm) {
        if (SHA1_WITH_RSA.sigAlgName.equalsIgnoreCase(algorithm)) {
            return SHA1_WITH_RSA;
        } else if (SHA256_WITH_RSA.sigAlgName.equalsIgnoreCase(algorithm)) {
            return SHA256_WITH_RSA;
        } else if (SHA384_WITH_RSA.sigAlgName.equalsIgnoreCase(algorithm)) {
            return SHA384_WITH_RSA;
        } else if (SHA512_WITH_RSA.sigAlgName.equalsIgnoreCase(algorithm)) {
            return SHA512_WITH_RSA;
        } else {
            return null;
        }
    }

    public static boolean checkSupportType(ASN1ObjectIdentifier aid) {
        return SdfSHAType.SHA1_WITH_RSA.getAid().getId().equalsIgnoreCase(aid.getId())
                || SdfSHAType.SHA256_WITH_RSA.getAid().getId().equalsIgnoreCase(aid.getId())
                || SdfSHAType.SHA384_WITH_RSA.getAid().getId().equalsIgnoreCase(aid.getId())
                || SdfSHAType.SHA512_WITH_RSA.getAid().getId().equalsIgnoreCase(aid.getId());
    }

}
