package com.xdja.pki.gmssl.crypto.sdf;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.util.encoders.Hex;

/**
 * @author sxy
 * @description
 * @date 2019年09月19日 17:32
 **/
public abstract class SdfSigner implements Signer, ECConstants {
    protected SdfSDK sdfSDK;

    /**
     * PKCS1填充
     * @param data 数据
     * @param length 填充后的长度
     * @return
     */
    protected byte[] pkcs1Padding(byte[] data, int length) {
        byte[] start = Hex.decode("0001");
        byte[] end = Hex.decode("00");
        //获取需要填充f的length
        int paddingLength = length - data.length - start.length - end.length;
        byte[] paddingData = new byte[paddingLength];
        for (int i = 0; i < paddingLength; i++) {
            paddingData[i] = -1;
        }
        byte[] a = GMSSLByteArrayUtils.mergeByteArray(start, paddingData);
        byte[] b = GMSSLByteArrayUtils.mergeByteArray(a, end);
        return GMSSLByteArrayUtils.mergeByteArray(b, data);
    }

    public void release() throws SdfSDKException {
        if (sdfSDK != null) {
            sdfSDK.release();
        }
    }
}
