/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie;

import com.xdja.pcie.DeviceInfo;
import com.xdja.pcie.ECCrefPrivateKey;
import com.xdja.pcie.ECCrefPublicKey;
import com.xdja.pcie.RSArefPrivateKey;
import com.xdja.pcie.RSArefPublicKey;
import com.xdja.pcie.SDFAPI;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPrivateKey;
import com.xdja.pki.gmssl.sdf.bean.SdfRSAPublicKey;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieSdfSDKUtils {
    private static int RSAref_MAX_LEN = 256;
    private static Logger logger = LoggerFactory.getLogger(PcieSdfSDKUtils.class);

    public static ECCrefPublicKey generateEccPublicKey(Logger logger, PublicKey key) {
        ECPublicKey ecPublicKey = (ECPublicKey)key;
        return PcieSdfSDKUtils.generateEccPublicKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineX()), GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPublicKey.getW().getAffineY()));
    }

    public static ECCrefPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        logger.info(key.toString());
        return PcieSdfSDKUtils.generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static ECCrefPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");
        ECCrefPublicKey pucPublicKey = new ECCrefPublicKey();
        pucPublicKey.setBits(256);
        pucPublicKey.setX(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])x));
        pucPublicKey.setY(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])y));
        return pucPublicKey;
    }

    public static ECCrefPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
        return PcieSdfSDKUtils.generateEccPrivateKey(logger, GMSSLByteArrayUtils.asUnsignedByteArray32((BigInteger)ecPrivateKey.getS()));
    }

    public static ECCrefPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        ECCrefPrivateKey pucPrivateKey = new ECCrefPrivateKey();
        pucPrivateKey.setBits(256);
        pucPrivateKey.setK(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])k));
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"pucPrivateKey k", (byte[])pucPrivateKey.getK());
        return pucPrivateKey;
    }

    public static void checkRet(String method, int ret, long dev, long ses) throws SdfSDKException {
        if (ret != 0) {
            logger.error("{} error! dev = {} session = {} ret = {} HEX={}:{}", new Object[]{method, dev, ses, ret, Integer.toHexString(ret), SdfApiCode.apiCodeToString((int)ret)});
            throw new SdfSDKException(method, ret);
        }
        logger.info(method + " success! dev = " + dev + " session = " + ses);
    }

    public static void openDevice(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.OpenDevice(dev);
        PcieSdfSDKUtils.checkRet("openDevice", ret, dev[0], 0L);
    }

    public static void openSession(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.OpenSession(dev[0], ses);
        PcieSdfSDKUtils.checkRet("openSession", ret, dev[0], ses[0]);
    }

    public static void closeSession(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        int ret = sdfApi.CloseSession(ses[0]);
        PcieSdfSDKUtils.checkRet("closeSession", ret, dev[0], ses[0]);
    }

    public static void closeDevice(SDFAPI sdfApi, long[] dev) throws SdfSDKException {
        int ret = sdfApi.CloseDevice(dev[0]);
        PcieSdfSDKUtils.checkRet("closeDevice", ret, dev[0], 0L);
    }

    public static String getDeviceInfo(SDFAPI sdfApi, long[] dev, long[] ses) throws SdfSDKException {
        DeviceInfo deviceInfo = new DeviceInfo();
        int ret = sdfApi.GetDeviceInfo(ses[0], deviceInfo);
        PcieSdfSDKUtils.checkRet("getDeviceInfo", ret, dev[0], ses[0]);
        return deviceInfo.toString();
    }

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }

    public static RSArefPublicKey generateRsaPublicKey(SdfRSAPublicKey rsaPublic) {
        RSArefPublicKey rsArefPublicKey = new RSArefPublicKey();
        rsArefPublicKey.setBits(rsaPublic.getBits());
        rsArefPublicKey.setE(rsaPublic.getE());
        rsArefPublicKey.setM(rsaPublic.getM());
        return rsArefPublicKey;
    }

    public static RSArefPrivateKey generateRsaPrivateKey(SdfRSAPrivateKey privateKey) {
        RSArefPrivateKey rsArefPrivateKey = new RSArefPrivateKey();
        rsArefPrivateKey.setCoef(privateKey.getCoef());
        rsArefPrivateKey.setD(privateKey.getD());
        rsArefPrivateKey.setBits(privateKey.getBits());
        rsArefPrivateKey.setE(GMSSLByteArrayUtils.changeByteArrayLength((byte[])privateKey.getE(), (int)RSAref_MAX_LEN));
        rsArefPrivateKey.setPrime(privateKey.getPrime());
        rsArefPrivateKey.setPexp(privateKey.getPexp());
        rsArefPrivateKey.setM(privateKey.getM());
        return rsArefPrivateKey;
    }
}

