/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pcie.base;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.io.Serializable;
import java.math.BigInteger;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class RSAPrivateKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int bits;
    private byte[] m = new byte[256];
    private byte[] e = new byte[256];
    private byte[] d = new byte[256];
    private byte[][] prime = new byte[2][128];
    private byte[][] pexp = new byte[2][128];
    private byte[] coef = new byte[128];

    public RSAPrivateKey() {
    }

    public RSAPrivateKey(int bits, byte[] m, byte[] e, byte[] d, byte[][] prime, byte[][] pexp, byte[] coef) {
        this.bits = bits;
        this.m = m;
        this.e = e;
        this.d = d;
        this.prime = prime;
        this.pexp = pexp;
        this.coef = coef;
    }

    public static RSAPrivateKey getInstance(BCRSAPrivateCrtKey rsaPrivateCrtKey) {
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey();
        rsaPrivateKey.setBits(rsaPrivateCrtKey.getModulus().bitLength());
        rsaPrivateKey.setM(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getModulus()), (int)256));
        rsaPrivateKey.setD(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPrivateExponent()), (int)256));
        rsaPrivateKey.setE(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPublicExponent()), (int)256));
        byte[] prime1 = GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPrimeP()), (int)128);
        byte[] prime2 = GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPrimeQ()), (int)128);
        byte[][] prime = new byte[2][128];
        prime[0] = prime1;
        prime[1] = prime2;
        byte[] pexp1 = GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPrimeExponentP()), (int)128);
        byte[] pexp2 = GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getPrimeExponentQ()), (int)128);
        byte[][] pxep = new byte[2][128];
        pxep[0] = pexp1;
        pxep[1] = pexp2;
        rsaPrivateKey.setCoef(GMSSLByteArrayUtils.changeByteArrayLength((byte[])BigIntegers.asUnsignedByteArray((BigInteger)rsaPrivateCrtKey.getCrtCoefficient()), (int)128));
        rsaPrivateKey.setPrime(prime);
        rsaPrivateKey.setPexp(pxep);
        return rsaPrivateKey;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getM() {
        return this.m;
    }

    public void setM(byte[] m) {
        this.m = m;
    }

    public byte[] getE() {
        return this.e;
    }

    public void setE(byte[] e) {
        this.e = e;
    }

    public byte[] getD() {
        return this.d;
    }

    public void setD(byte[] d) {
        this.d = d;
    }

    public byte[][] getPrime() {
        return this.prime;
    }

    public void setPrime(byte[][] prime) {
        this.prime = prime;
    }

    public byte[][] getPexp() {
        return this.pexp;
    }

    public void setPexp(byte[][] pexp) {
        this.pexp = pexp;
    }

    public byte[] getCoef() {
        return this.coef;
    }

    public void setCoef(byte[] coef) {
        this.coef = coef;
    }

    public byte[] getPrime0() {
        return this.prime[0];
    }

    public byte[] getPrime1() {
        return this.prime[1];
    }

    public byte[] getPexp0() {
        return this.pexp[0];
    }

    public byte[] getPexp1() {
        return this.pexp[1];
    }

    public String toString() {
        return "RSAPrivateKey [bits=" + this.bits + ", m=" + Hex.toHexString((byte[])this.m) + ", e=" + Hex.toHexString((byte[])this.e) + ", d=" + Hex.toHexString((byte[])this.d) + ", prime=" + this.arrays(this.prime) + ", pexp=" + this.arrays(this.pexp) + ", coef=" + Hex.toHexString((byte[])this.coef) + "]";
    }

    public String arrays(byte[][] arrs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrs.length; ++i) {
            sb.append(i + " " + Hex.toHexString((byte[])arrs[i]) + " ");
        }
        return sb.toString();
    }
}

