/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pcie.sdf.jni;

import com.xdja.pcie.SDFAPI;
import com.xdja.pcie.base.DeviceInfo;
import com.xdja.pcie.base.ECCCipher;
import com.xdja.pcie.base.ECCPrivateKey;
import com.xdja.pcie.base.ECCPublicKey;
import com.xdja.pcie.base.ECCSignature;
import com.xdja.pcie.sdf.jni.alg.AlgId;
import java.util.Arrays;
import java.util.Scanner;

public class SdfApiDemo {
    public static int init(SDFAPI sa, long[] dev, long[] ses) {
        int ret = sa.openDevice(dev);
        if (ret != 0) {
            System.out.println(String.format("OpenDevice error, ret = %X", ret));
            return ret;
        }
        ret = sa.openSession(dev[0], ses);
        if (ret != 0) {
            System.out.println(String.format("OpenSession error, ret = %X", ret));
            return ret;
        }
        return 0;
    }

    public static void error(int ret, String message, SDFAPI sa, long[] dev, long[] ses) {
        if (ret != 0) {
            System.out.println(String.format(message + " error, ret = %X", ret));
            if (ses[0] != 0L) {
                sa.closeSession(ses[0]);
            }
            if (dev[0] != 0L) {
                sa.closeDevice(dev[0]);
            }
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sample() throws Exception {
        SDFAPI sa = new SDFAPI();
        long[] dev = new long[]{0L};
        long[] ses = new long[]{0L};
        long[] phKeyHandle = new long[]{0L};
        long[] phAgreementHandle = new long[]{0L};
        int uiKeyIndex = 10;
        int uiKekIndex = 10;
        String pwd = "xdja1234";
        byte[] pucPassword = pwd.getBytes();
        int uiPassword = 8;
        int uiKeyBits_ECC = 256;
        int uiKeyBits_SES = 128;
        ECCPublicKey pucPublicKey = new ECCPublicKey();
        ECCPublicKey pucPublicKey_tmp = new ECCPublicKey();
        ECCPublicKey pucResponsepublicKey = new ECCPublicKey();
        ECCPublicKey pucResponsepublicKey_tmp = new ECCPublicKey();
        ECCPrivateKey pucPrivateKey = new ECCPrivateKey();
        ECCCipher pucKey = new ECCCipher();
        ECCCipher pucEncDateIn = new ECCCipher();
        ECCCipher pucEncDateOut = new ECCCipher();
        String pucSponaorID_t = "abcdefghijkl";
        byte[] pucSponaorID = pucSponaorID_t.getBytes();
        String pucResponseID_t = "ABCDEFGHIJKL";
        byte[] pucResponseID = pucResponseID_t.getBytes();
        int pucSponaorlen = 12;
        int pucResponselen = 12;
        byte[] pucKeyEcc = new byte[]{0};
        int[] pucKeyEccLen = new int[]{0};
        String pucDate_t = "asdfsdflrncefcjfasdfsdflrncefcjf";
        byte[] pucDate = pucDate_t.getBytes();
        int[] pucDateLen = new int[]{pucDate.length};
        ECCSignature pucSignature = new ECCSignature();
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        byte[] pucDate_1 = new byte[1024];
        int[] pucEncDateLen = new int[]{1024};
        byte[] PucID = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        int PucIDLen = 8;
        byte[] PucHash = new byte[1024];
        int[] PucHashLen = new int[]{1024};
        String pucFileName_t = "java_test.txt";
        byte[] pucFileName = pucFileName_t.getBytes();
        int pucFileNameLen = 13;
        int uiFileSize = 1024;
        int uiOffset = 5;
        int[] puiFileLength = new int[]{16};
        String pucBuffer_t = "123qweasdcxzvfr4";
        byte[] pucBuffer = pucBuffer_t.getBytes();
        byte[] pucBuffer_r = new byte[1024];
        try {
            int ret = SdfApiDemo.init(sa, dev, ses);
            if (ret != 0) {
                System.out.println(String.format("init error, ret = %X", ret));
                return;
            }
            Scanner number = new Scanner(System.in);
            System.out.print("enter a number: ");
            int id = number.nextInt();
            switch (id) {
                case 1: {
                    DeviceInfo devinfo = new DeviceInfo();
                    ret = sa.getDeviceInfo(ses[0], devinfo);
                    SdfApiDemo.error(ret, "getDeviceInfo is error", sa, dev, ses);
                    System.out.println(devinfo.toString());
                    return;
                }
                case 2: {
                    byte[] pucRandom = new byte[16];
                    int uiLength = 16;
                    ret = sa.generateRandom(ses[0], uiLength, pucRandom);
                    SdfApiDemo.error(ret, "generaterandom is error", sa, dev, ses);
                    System.out.println(Arrays.toString(pucRandom));
                    return;
                }
                case 3: {
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    SdfApiDemo.error(ret, "getprivateKeyAccessRight is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 4: {
                    ret = sa.releasePrivateKeyAccessRight(ses[0], uiKeyIndex);
                    SdfApiDemo.error(ret, "getprivateKeyAccessRight is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 5: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 6: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 7: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 8: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 9: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 10: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 11: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 12: {
                    ret = sa.exportSignPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    SdfApiDemo.error(ret, "exportSignPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    return;
                }
                case 13: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    SdfApiDemo.error(ret, "exportEncPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    return;
                }
                case 14: {
                    ret = sa.generateKeyPairECC(ses[0], AlgId.SGD_SM2, uiKeyBits_ECC, pucPublicKey, pucPrivateKey);
                    SdfApiDemo.error(ret, "exportEncPublicKeyEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucPrivateKey);
                    return;
                }
                case 15: {
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithIpkEcc is error", sa, dev, ses);
                    System.out.println(pucKey);
                    return;
                }
                case 16: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    sa.generateKeyWithEPKECC(ses[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithEpkEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucKey);
                    return;
                }
                case 17: {
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.importKeyWithISKECC(ses[0], uiKeyIndex, pucKey, phKeyHandle);
                    SdfApiDemo.error(ret, "importKeyWithIskEcc is error", sa, dev, ses);
                    System.out.println(pucKey);
                    return;
                }
                case 18: {
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    SdfApiDemo.error(ret, "generateAgreementDataWithEcc is error", sa, dev, ses);
                    System.out.println(pucPublicKey);
                    System.out.println(pucPublicKey_tmp);
                    return;
                }
                case 19: {
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    ret = sa.generateKeyWithECC(ses[0], pucResponseID, pucResponselen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle[0], phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithEcc is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 20: {
                    ret = sa.generateAgreementDataWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, phAgreementHandle);
                    ret = sa.generateAgreementDataAndKeyWithECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucResponseID, pucResponselen, pucSponaorID, pucSponaorlen, pucPublicKey, pucPublicKey_tmp, pucResponsepublicKey, pucResponsepublicKey_tmp, phKeyHandle);
                    SdfApiDemo.error(ret, "generateAgreementDataAndKeyWithEcc is error", sa, dev, ses);
                    System.out.println(pucResponsepublicKey);
                    System.out.println(pucResponsepublicKey_tmp);
                    return;
                }
                case 21: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucEncDateIn, phKeyHandle);
                    ret = sa.exchangeDigitEnvelopeBaseOnECC(ses[0], uiKeyIndex, AlgId.SGD_SM2, pucPublicKey, pucEncDateIn, pucEncDateOut);
                    SdfApiDemo.error(ret, "exchangeDigitEnvelopeOnEcc is error", sa, dev, ses);
                    System.out.println(pucEncDateOut);
                    return;
                }
                case 22: {
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    SdfApiDemo.error(ret, "generateKeyWithKek is error", sa, dev, ses);
                    System.out.println(pucKeyEcc.toString());
                    System.out.println(pucKeyEccLen[0]);
                    return;
                }
                case 23: {
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    ret = sa.importKeyWithKEK(ses[0], AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen[0], phKeyHandle);
                    SdfApiDemo.error(ret, "importKeyWithKek is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 24: {
                    ret = sa.generateKeyWithKEK(ses[0], uiKeyBits_SES, AlgId.SGD_SM1_ECB, uiKekIndex, pucKeyEcc, pucKeyEccLen, phKeyHandle);
                    ret = sa.destroyKey(ses[0], phKeyHandle[0]);
                    SdfApiDemo.error(ret, "destroyKey is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 25: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 26: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 27: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
                case 28: {
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    ret = sa.externalVerifyECC(ses[0], AlgId.SGD_SM2, pucPublicKey, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "externalVerifyEcc is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 29: {
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "internalSignEcc is error", sa, dev, ses);
                    System.out.println(pucSignature);
                    return;
                }
                case 30: {
                    ret = sa.getPrivateKeyAccessRight(ses[0], uiKeyIndex, pucPassword, uiPassword);
                    ret = sa.internalSignECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    ret = sa.internalVerifyECC(ses[0], uiKeyIndex, pucDate, pucDate.length, pucSignature);
                    SdfApiDemo.error(ret, "internalVerifyEcc is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 31: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.externalEncryptECC(ses[0], AlgId.SGD_SM2, pucPublicKey, pucDate, pucDate.length, pucEncDateOut);
                    SdfApiDemo.error(ret, "externalEncryptEcc is error", sa, dev, ses);
                    System.out.println(pucEncDateOut);
                    return;
                }
                case 32: {
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.encrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
                    SdfApiDemo.error(ret, "encrypt is error", sa, dev, ses);
                    System.out.println(new String(pucEncDate));
                    System.out.println(pucEncDateLen[0]);
                    return;
                }
                case 33: {
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.encrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucDate, pucDateLen[0], pucEncDate, pucEncDateLen);
                    ret = sa.decrypt(ses[0], phKeyHandle[0], AlgId.SGD_SM1_ECB, pucIV, pucEncDate, pucEncDateLen[0], pucDate_1, pucDateLen);
                    SdfApiDemo.error(ret, "decrypt is error", sa, dev, ses);
                    System.out.println(new String(pucDate_1));
                    System.out.println(pucDateLen[0]);
                    return;
                }
                case 34: {
                    ret = sa.generateKeyWithIPKECC(ses[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
                    ret = sa.calculateMac(ses[0], phKeyHandle[0], AlgId.SGD_SM1_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
                    SdfApiDemo.error(ret, "calculateMac is error", sa, dev, ses);
                    System.out.println(new String(pucEncDate));
                    System.out.println(pucEncDateLen[0]);
                    return;
                }
                case 35: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    SdfApiDemo.error(ret, "hashInit is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 36: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    ret = sa.hashUpdate(ses[0], pucDate, pucDate.length);
                    SdfApiDemo.error(ret, "hashUpdate is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 37: {
                    ret = sa.exportEncPublicKeyECC(ses[0], uiKeyIndex, pucPublicKey);
                    ret = sa.hashInit(ses[0], AlgId.SGD_SM3, pucPublicKey, PucID, PucIDLen);
                    ret = sa.hashFinal(ses[0], PucHash, PucHashLen);
                    SdfApiDemo.error(ret, "hashFinal is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 38: {
                    ret = sa.createFile(ses[0], pucFileName, pucFileName.length, uiFileSize);
                    SdfApiDemo.error(ret, "createFile is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 39: {
                    ret = sa.readFile(ses[0], pucFileName, pucFileName.length, uiOffset, puiFileLength, pucBuffer_r);
                    SdfApiDemo.error(ret, "readFile is error", sa, dev, ses);
                    System.out.println(puiFileLength[0]);
                    System.out.println(new String(pucBuffer_r));
                    return;
                }
                case 40: {
                    ret = sa.writeFile(ses[0], pucFileName, pucFileNameLen, uiOffset, pucBuffer.length, pucBuffer);
                    SdfApiDemo.error(ret, "writeFile is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                case 41: {
                    ret = sa.deleteFile(ses[0], pucFileName, pucFileNameLen);
                    SdfApiDemo.error(ret, "deleteFile is error", sa, dev, ses);
                    System.out.println("success");
                    return;
                }
                default: {
                    System.out.println(String.format("unknown id value, plases input new id!", new Object[0]));
                    return;
                }
            }
        }
        finally {
            if (ses[0] != 0L) {
                sa.closeSession(ses[0]);
            }
            if (dev[0] != 0L) {
                sa.closeDevice(dev[0]);
            }
        }
    }
}

