package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.DeviceInfo;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmConnection {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SdfApi sdfApi = new SdfApi();
    private long[] dev = {0}, ses = {0};
    private int id;
    private long startTime;

    HsmConnection() throws SdfSDKException {
        init();
    }

    HsmConnection(String configPath) throws SdfSDKException {
        initWithConfigPath(configPath);
    }

    public SdfApi getSdfApi() {
        return sdfApi;
    }

    public long[] getDev() {
        return dev;
    }

    public long[] getSes() {
        return ses;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private void checkRet(String method, int ret) throws SdfSDKException {
        if (ret != 0) {
            logger.error(
                    "{} error! dev = {} session = {} ret = {} HEX = {} String = {}",
                    method,
                    dev[0],
                    ses[0],
                    ret,
                    Integer.toHexString(ret),
                    SdfApiCode.apiCodeToString(ret)
            );
            throw new SdfSDKException(method, ret);
        } else {
//            logger.info(method + " success! dev = {} session = {}", dev[0], ses[0]);
        }
    }

    public void init() throws SdfSDKException {
        if (ses == null || ses.length == 0 || ses[0] == 0) {
            //获取配置文件
            String cfg = System.getenv("YUNHSMSDK_CONF");
            if (cfg == null) {
                logger.error("getenv(\"YUNHSMSDK_CONF\") return null, please set this env variable");
                throw new SdfSDKException("get system config error");
            }

            initWithConfigPath(cfg);
        }
    }

    private void initWithConfigPath(String configPath) throws SdfSDKException {
        //打开设备
        int ret = sdfApi.openDevice(dev);
        checkRet("openDevice", ret);

        //使用配置文件初始化设备
        ret = sdfApi.initialize(dev[0], configPath.getBytes());
        checkRet("initialize", ret);

        //打开 session
        ret = sdfApi.openSession(dev[0], ses);
        checkRet("openSession", ret);
//        logger.debug("init dev = {} session = {}", dev[0], ses[0]);
    }

    public void release() throws SdfSDKException {
        logger.debug("release dev = {} session = {}", dev[0], ses[0]);
        int ret = sdfApi.closeSession(ses[0]);
        checkRet("closeSession", ret);
        ret = sdfApi.closeDevice(dev[0]);
        checkRet("closeDevice", ret);
        this.dev = new long[]{0};
        this.ses = new long[]{0};
    }

    public void getDeviceInfo() throws SdfSDKException {
        logger.debug("getDeviceInfo dev = {} session = {}", dev[0], ses[0]);
        DeviceInfo devinfo = new DeviceInfo();
        int ret = sdfApi.getDeviceInfo(ses[0], devinfo);
        checkRet("getDeviceInfo", ret);
        logger.info(devinfo.toString());
    }

}
