package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.*;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.*;
import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class YunhsmSdfSDK extends AbstractSdfSDK {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

//    private SdfApi sdfApi = new SdfApi();

    @Override
    public void init() throws SdfSDKException {
//        if (ses == null || ses.length == 0 || ses[0] == 0) {
//            //获取配置文件
//            String cfg = System.getenv("YUNHSMSDK_CONF");
//            if (cfg == null) {
//                logger.error("getenv(\"YUNHSMSDK_CONF\") return null, please set this env variable");
//                throw new SdfSDKException("get system config error");
//            }
//
//            //打开设备
//            int ret = sdfApi.openDevice(dev);
//            checkRet("openDevice", ret, connection);
//
//            //使用配置文件初始化设备
//            ret = sdfApi.initialize(dev[0], cfg.getBytes());
//            checkRet("initialize", ret, connection);
//
//            //打开 session
//            ret = sdfApi.openSession(dev[0], ses);
//            checkRet("openSession", ret, connection);
//        }
    }

    @Override
    public void release() throws SdfSDKException {
//        int ret = sdfApi.closeSession(ses[0]);
//        checkRet("closeSession", ret, connection);
//        ret = sdfApi.closeDevice(dev[0]);
//        checkRet("closeDevice", ret, connection);
//        this.dev = new long[]{0};
//        this.ses = new long[]{0};
    }

    protected void checkRet(String method, int ret, HsmConnection connection) throws SdfSDKException {
        if (ret != 0) {
            logger.error(
                    "{} error! dev = {} session = {} ret = {} HEX={}:{}",
                    method,
                    connection.getDev()[0],
                    connection.getSes()[0],
                    ret,
                    Integer.toHexString(ret),
                    SdfApiCode.apiCodeToString(ret)
            );
            throw new SdfSDKException(method, ret);
        } else {
//            logger.info(method + " success! dev = " + connection.getDev()[0] + " session = " + connection.getSes()[0]);
        }
    }

    public void releaseConnection() {
        if (sm3HsmConnection != null) {
            HsmConnectionPool.getInstance().releaseConnection(sm3HsmConnection);
            sm3HsmConnection = null;
        }
        if (symmetricHsmConnection != null) {
            HsmConnectionPool.getInstance().releaseConnection(symmetricHsmConnection);
            symmetricHsmConnection = null;
        }
    }

    @Override
    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("generateRandom", ret, connection);
        return pucRandom;
    }

    @Override
    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        //ECC签名公钥  ECC加密公钥
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("generateKeyPairEcc", ret, connection);
//        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucPrivateKey.getK());
        return new SdfECCKeyPair(
                SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY()),
                SdfECCPrivateKey.getInstanceFilterHead(pucPrivateKey.getK())
        );
    }

    @Override
    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == SdfApiCode.SDR_OK) {
            result = true;
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        return result;
    }

    private void getPrivateKeyAccessRight(HsmConnection connection, int index, byte[] password) throws SdfSDKException {
        logger.debug("start get private key access index={} password={}!", index, new String(password));
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        // 私钥访问控制码错误
        if (ret == SdfApiCode.SDR_PRKRERR) {
            logger.debug("getPrivateKeyAccessRight fail password may be wrong, index={} password={}", index, new String(password));
            return;
        }
        // 私钥访问控制码 竞争
        if (ret == SdfApiCode.SDR_PARDENY) {
            for (int i = 0; i < 5; i++) {
                ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
                if (ret == SdfApiCode.SDR_PARDENY) {
                    logger.debug("getPrivateKeyAccessRight fail count {}, index={} password={}", i, index, new String(password));
                    continue;
                }
                if (ret == SdfApiCode.SDR_OK) {
                    logger.debug("getPrivateKeyAccessRight success count {}", i);
                    return;
                }
            }
        }
        checkRet("getPrivateKeyAccessRight", ret, connection);
    }

    private void releasePrivateKeyAccessRight(HsmConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        checkRet("releasePrivateKeyAccessRight", ret, connection);
    }

    @Override
    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        EccSignature pucSignature = new EccSignature();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        }
        while (ret == SdfApiCode.SDR_PARDENY) {
            logger.debug("internalSignECC get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        }
        this.releasePrivateKeyAccessRight(connection, index);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("internalSignECC", ret, connection);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    @Override
    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportSignPublicKeyEcc", ret, connection);
        return SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCSignature.getS());
        EccSignature pucSignature = new EccSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(publicKey.getY());
        EccPublicKey pucPublicKey = new EccPublicKey(GMSSLX509Utils.ECC_KEY_BITS, x, y);
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucSignature);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucSignature);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("externalVerifyECC", ret, connection);
    }

    @Override
    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("exportEncPublicKeyEcc", ret, connection);
        return SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        EccCipher pucEncData = new EccCipher();
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, publicKey.getX(), publicKey.getY());
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucEncData);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], AlgId.SGD_SM2, pucPublicKey, data, data.length, pucEncData);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("externalEncryptECC", ret, connection);
        GMSSLByteArrayUtils.printHexBinary(logger, "enc data x", pucEncData.getX());
        GMSSLByteArrayUtils.printHexBinary(logger, "enc data y", pucEncData.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    @Override
    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getY());
        EccCipher pucEncData = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = {len};
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        }
        while (ret == SdfApiCode.SDR_PARDENY) {
            logger.debug("internalDecryptECC get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
        }
        this.releasePrivateKeyAccessRight(connection, index);
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("internalDecryptEcc", ret, connection);
        return pucData;
    }

    private HsmConnection symmetricHsmConnection;

    @Override
    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    @Override
    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    @Override
    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        int uiKeyBits_SES = 128;
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
        EccCipher pucKey = new EccCipher();
        if (symmetricHsmConnection == null || symmetricHsmConnection.getDev()[0] == 0 || symmetricHsmConnection.getSes()[0] == 0) {
            symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        }
        int ret = symmetricHsmConnection.getSdfApi().generateKeyWithEpkEcc(symmetricHsmConnection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            symmetricHsmConnection.release();
            symmetricHsmConnection.init();
            ret = symmetricHsmConnection.getSdfApi().generateKeyWithEpkEcc(symmetricHsmConnection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }
        checkRet("generateKeyWithEpkEcc", ret, symmetricHsmConnection);
        GMSSLByteArrayUtils.printHexBinary(logger, "enc data x", pucKey.getX());
        GMSSLByteArrayUtils.printHexBinary(logger, "enc data y", pucKey.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    @Override
    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = {0};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getY());
        EccCipher pucKey = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        if (symmetricHsmConnection == null) {
            symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        }
        this.getPrivateKeyAccessRight(symmetricHsmConnection, uiIskIndex, password);
        int ret = symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            symmetricHsmConnection.release();
            symmetricHsmConnection.init();
            ret = symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        while (ret == SdfApiCode.SDR_PARDENY) {
            logger.debug("importKeyWithIskEcc get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
            this.getPrivateKeyAccessRight(symmetricHsmConnection, uiIskIndex, password);
            ret = symmetricHsmConnection.getSdfApi().importKeyWithIskEcc(symmetricHsmConnection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }
        this.releasePrivateKeyAccessRight(symmetricHsmConnection, uiIskIndex);
        checkRet("importKeyWithIskEcc", ret, symmetricHsmConnection);
        return phKeyHandle;
    }

    @Override
    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        symmetricHsmConnection = HsmConnectionPool.getInstance().getConnection();
        int ret = symmetricHsmConnection.getSdfApi().importKey(symmetricHsmConnection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            symmetricHsmConnection.release();
            symmetricHsmConnection.init();
            ret = symmetricHsmConnection.getSdfApi().importKey(symmetricHsmConnection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        checkRet("importKey", ret, symmetricHsmConnection);
        return phKeyHandle;
    }

    @Override
    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = {pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = symmetricHsmConnection.getSdfApi().encrypt(symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            symmetricHsmConnection.release();
            symmetricHsmConnection.init();
            ret = symmetricHsmConnection.getSdfApi().encrypt(symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        checkRet("encrypt", ret, symmetricHsmConnection);
        return pucEncData;
    }

    @Override
    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = {pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        int ret = symmetricHsmConnection.getSdfApi().decrypt(symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            symmetricHsmConnection.release();
            symmetricHsmConnection.init();
            ret = symmetricHsmConnection.getSdfApi().decrypt(symmetricHsmConnection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        checkRet("decrypt", ret, symmetricHsmConnection);
        return pucData;
    }

    @Override
    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (symmetricHsmConnection != null) {
            int ret = symmetricHsmConnection.getSdfApi().destroyKey(symmetricHsmConnection.getSes()[0], phKeyHandle[0]);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                symmetricHsmConnection.release();
                symmetricHsmConnection.init();
                ret = symmetricHsmConnection.getSdfApi().destroyKey(symmetricHsmConnection.getSes()[0], phKeyHandle[0]);
            }
            HsmConnectionPool.getInstance().releaseConnection(symmetricHsmConnection);
            checkRet("destroyKey", ret, symmetricHsmConnection);
        }
    }

    private HsmConnection sm3HsmConnection;

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        sm3HsmConnection = HsmConnectionPool.getInstance().getConnection();
        int ret = sm3HsmConnection.getSdfApi().hashInit(sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            sm3HsmConnection.release();
            sm3HsmConnection.init();
            ret = sm3HsmConnection.getSdfApi().hashInit(sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        checkRet("hashInit", ret, sm3HsmConnection);
    }

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
        sm3HsmConnection = HsmConnectionPool.getInstance().getConnection();
//        logger.info("hashInit session {}", sm3HsmConnection.getSes()[0]);
        int ret = sm3HsmConnection.getSdfApi().hashInit(sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            sm3HsmConnection.release();
            sm3HsmConnection.init();
            ret = sm3HsmConnection.getSdfApi().hashInit(sm3HsmConnection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        checkRet("hashInit", ret, sm3HsmConnection);
    }

    @Override
    public void hashUpdate(byte[] data) throws SdfSDKException {
//        logger.info("hashUpdate session {}", sm3HsmConnection.getSes()[0]);
        int ret = sm3HsmConnection.getSdfApi().hashUpdate(sm3HsmConnection.getSes()[0], data, data.length);
        checkRet("hashUpdate", ret, sm3HsmConnection);
    }

    @Override
    public byte[] hashFinal() throws SdfSDKException {
        byte[] pucHash = new byte[32];
        int[] pucHashLen = {32};
        if (sm3HsmConnection != null) {
//            logger.info("hashFinal session {}", sm3HsmConnection.getSes()[0]);
            int ret = sm3HsmConnection.getSdfApi().hashFinal(sm3HsmConnection.getSes()[0], pucHash, pucHashLen);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                sm3HsmConnection.release();
                sm3HsmConnection.init();
                ret = sm3HsmConnection.getSdfApi().hashFinal(sm3HsmConnection.getSes()[0], pucHash, pucHashLen);
            }
            HsmConnectionPool.getInstance().releaseConnection(sm3HsmConnection);
            checkRet("hashFinal", ret, sm3HsmConnection);
        }
        return pucHash;
    }

    @Override
    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int ret;
        int uiKeyBits_SES = 128;

        long[] phKeyHandle = {0};
        EccCipher pucKey = new EccCipher();

        //对称算法运算类函数缓冲区指针定义
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = {1024};

        //要加密的数据 和数据长度
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();

        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        ret = connection.getSdfApi().generateKeyWithIpkEcc(connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        checkRet("generateKeyWithIpkEcc", ret, connection);
        ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("calculateMac", ret, connection);
    }

    @Override
    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        throw new SdfSDKException("yunhsm unsupport sm3 hmac");
    }

    public void testConnect() throws SdfSDKException {
        HsmConnection connection = new HsmConnection();
        connection.getDeviceInfo();
        connection.release();
    }

    public void testConnect(String configPath) throws SdfSDKException {
        HsmConnection connection = new HsmConnection(configPath);
        connection.getDeviceInfo();
        connection.release();
    }

    @Override
    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportSignPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("exportSignPublicKeyRsa", ret, connection);
        return SdfRSAPublicKey.getInstanceFilterHead(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().exportEncPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("exportEncPublicKeyRsa", ret, connection);
        return SdfRSAPublicKey.getInstanceFilterHead(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        RsaPublicKey rsaPublicKey = new RsaPublicKey();
        RsaPrivateKey rsaPrivateKey = new RsaPrivateKey();
        int ret = connection.getSdfApi().generateKeyPairRsa(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().generateKeyPairRsa(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("generateKeyPairRsa", ret, connection);
        SdfRSAPrivateKey sdfRSAPrivateKey = new SdfRSAPrivateKey(rsaPrivateKey.getBits(), rsaPrivateKey.getM(), rsaPrivateKey.getE(), rsaPrivateKey.getD(),
                rsaPrivateKey.getPrime(), rsaPrivateKey.getPexp(), rsaPrivateKey.getCoef());
        SdfRSAPublicKey sdfRSAPublicKey = new SdfRSAPublicKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE());
        return new SdfRsaKeyPair(sdfRSAPrivateKey, sdfRSAPublicKey);
    }

    @Override
    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = {1024};
        byte[] m = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfRSAPublicKey.getM(), 256);
        byte[] e = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfRSAPublicKey.getE(), 256);
        RsaPublicKey rsaPublicKey = new RsaPublicKey(sdfRSAPublicKey.getBits(), m, e);
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        int ret = connection.getSdfApi().externalPublicKeyOperationRsa(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().externalPublicKeyOperationRsa(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("externalPublicKeyOperationRsa", ret, connection);
        return pucDataOutPut;
    }

    @Override
    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        int[] puiDataOutPutLength = {1024};
        SdfRSAPublicKey sdfRSAPublicKey = this.exportSignPublicKeyRsa(index);
        byte[] pucDataOutPut = new byte[sdfRSAPublicKey.getBits() / 8];
        HsmConnection connection = HsmConnectionPool.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.release();
            connection.init();
            ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        while (ret == SdfApiCode.SDR_PARDENY) {
            logger.debug("internalPrivateKeyOperationRsa get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
            this.getPrivateKeyAccessRight(connection, index, password);
            ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        HsmConnectionPool.getInstance().releaseConnection(connection);
        checkRet("internalPrivateKeyOperationRsa", ret, connection);
        return pucDataOutPut;
    }

}
