package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.bean.EccPrivateKey;
import com.xdja.hsm.api.bean.EccPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.bean.SdfECCPublicKey;
import org.slf4j.Logger;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;

public class YunhsmSdfSDKUtils {

    /************************************************************************************************
     * JAVA to SDF
     *************************************************************************************************/
    public static EccPublicKey generateEccPublicKey(Logger logger, SdfECCPublicKey key) {
        return generateEccPublicKey(logger, key.getX(), key.getY());
    }

    public static EccPublicKey generateEccPublicKey(Logger logger, byte[] x, byte[] y) {
        logger.info("generateEccPublicKey");

        EccPublicKey pucPublicKey = new EccPublicKey(
                GMSSLX509Utils.ECC_KEY_BITS,
                GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(x),
                GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(y)
        );

        GMSSLByteArrayUtils.printHexBinary(logger, "EccPublicKey x", pucPublicKey.getX());
        GMSSLByteArrayUtils.printHexBinary(logger, "EccPublicKey y", pucPublicKey.getY());
        return pucPublicKey;
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, PrivateKey key) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey) key;
        return generateEccPrivateKey(logger, ecPrivateKey.getS().toByteArray());
    }

    public static EccPrivateKey generateEccPrivateKey(Logger logger, byte[] k) {
        logger.info("generateEccPrivateKey");
        EccPrivateKey pucPrivateKey = new EccPrivateKey(
                GMSSLX509Utils.ECC_KEY_BITS,
                GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(k)
        );
        GMSSLByteArrayUtils.printHexBinary(logger, "pucPrivateKey k", pucPrivateKey.getK());
        return pucPrivateKey;
    }

    /************************************************************************************************
     * SDF to JAVA
     *************************************************************************************************/

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate certificate = (X509Certificate) factory.generateCertificate(inputStream);
        return certificate.getPublicKey();
    }
}
