package com.xdja.hsm.api.bean;

import java.io.Serializable;
import java.util.Arrays;

/**
 * ECC加密数据实体定义
 * @author wyf
 *
 */
public class EccCipher implements Serializable {

	private static final long serialVersionUID = 1L;
	
	/**
	 * x分量
	 */
	private byte[] x = new byte[EccPublicKey.ECC_MAX_LEN];
	/**
	 * y分量
	 */
	private byte[] y = new byte[EccPublicKey.ECC_MAX_LEN];
	/**
	 * 明文的杂凑值
	 */
	private byte[] m = new byte[32];
	/**
	 * 密文数据长度
	 */
	private int l;
	/**
	 * 密文数据
	 */
	private byte[] c = new byte[l];
	
	public EccCipher() {
		super();
	}

	public EccCipher(byte[] x, byte[] y, byte[] m, int l, byte[] c) {
		super();
		this.x = x;
		this.y = y;
		this.m = m;
		this.l = l;
		this.c = c;
	}

	/**
	 * 获得 x
	 * @return x 参见 {@linkplain #x} 
	 */
	public byte[] getX() {
		return x;
	}

	/**
	 * 设置 x
	 * @param x 参见 {@linkplain #x}
	 */
	public void setX(byte[] x) {
		this.x = x;
	}

	/**
	 * 获得 y
	 * @return y 参见 {@linkplain #y} 
	 */
	public byte[] getY() {
		return y;
	}

	/**
	 * 设置 y
	 * @param y 参见 {@linkplain #y}
	 */
	public void setY(byte[] y) {
		this.y = y;
	}

	/**
	 * 获得 m
	 * @return m 参见 {@linkplain #m} 
	 */
	public byte[] getM() {
		return m;
	}

	/**
	 * 设置 m
	 * @param m 参见 {@linkplain #m}
	 */
	public void setM(byte[] m) {
		this.m = m;
	}

	/**
	 * 获得 l
	 * @return l 参见 {@linkplain #l} 
	 */
	public int getL() {
		return l;
	}

	/**
	 * 设置 l
	 * @param l 参见 {@linkplain #l}
	 */
	public void setL(int l) {
		this.l = l;
	}

	/**
	 * 获得 c
	 * @return c 参见 {@linkplain #c} 
	 */
	public byte[] getC() {
		return c;
	}

	/**
	 * 设置 c
	 * @param c 参见 {@linkplain #c}
	 */
	public void setC(byte[] c) {
		this.c = c;
	}

	@Override
	public String toString() {
		return "EccCipher [x=" + Arrays.toString(x) + ", y=" + Arrays.toString(y) + ", m=" + Arrays.toString(m) + ", l="
				+ l + ", c=" + Arrays.toString(c) + "]";
	}

}
