package com.xdja.hsm.api.bean;

import java.io.Serializable;
import java.util.Arrays;

/**
 * RSA公钥数据实体定义
 * @author wyf
 *
 */
public class RsaPublicKey implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public final static int RSA_MAX_BITS = 4096;
	public final static int RSA_MAX_LEN = (RSA_MAX_BITS + 7) / 8;
	public final static int RSA_MAX_PBITS = (RSA_MAX_BITS + 1) / 2;
	public final static int RSA_MAX_PLEN = (RSA_MAX_PBITS + 7) / 8;
	
	/**
	 * 模长
	 */
	private int bits;
	/**
	 * 模N
	 */
	private byte[] m = new byte[RSA_MAX_LEN];
	/**
	 * 公钥指数
	 */
	private byte[] e = new byte[RSA_MAX_LEN];

	public RsaPublicKey() {
		super();
	}

	public RsaPublicKey(int bits, byte[] m, byte[] e) {
		super();
		this.bits = bits;
		this.m = m;
		this.e = e;
	}

	/**
	 * 获得 bits
	 * @return bits 参见 {@linkplain #bits} 
	 */
	public int getBits() {
		return bits;
	}

	/**
	 * 设置 bits
	 * @param bits 参见 {@linkplain #bits}
	 */
	public void setBits(int bits) {
		this.bits = bits;
	}

	/**
	 * 获得 m
	 * @return m 参见 {@linkplain #m} 
	 */
	public byte[] getM() {
		return m;
	}

	/**
	 * 设置 m
	 * @param m 参见 {@linkplain #m}
	 */
	public void setM(byte[] m) {
		this.m = m;
	}

	/**
	 * 获得 e
	 * @return e 参见 {@linkplain #e} 
	 */
	public byte[] getE() {
		return e;
	}

	/**
	 * 设置 e
	 * @param e 参见 {@linkplain #e}
	 */
	public void setE(byte[] e) {
		this.e = e;
	}

	/**
	 * 获得 rsaMaxBits
	 * @return rsaMaxBits 参见 {@linkplain #rsaMaxBits} 
	 */
	public static int getRsaMaxBits() {
		return RSA_MAX_BITS;
	}

	/**
	 * 获得 rsaMaxLen
	 * @return rsaMaxLen 参见 {@linkplain #rsaMaxLen} 
	 */
	public static int getRsaMaxLen() {
		return RSA_MAX_LEN;
	}

	/**
	 * 获得 rsaMaxPbits
	 * @return rsaMaxPbits 参见 {@linkplain #rsaMaxPbits} 
	 */
	public static int getRsaMaxPbits() {
		return RSA_MAX_PBITS;
	}

	/**
	 * 获得 rsaMaxPlen
	 * @return rsaMaxPlen 参见 {@linkplain #rsaMaxPlen} 
	 */
	public static int getRsaMaxPlen() {
		return RSA_MAX_PLEN;
	}

	@Override
	public String toString() {
		return "RsaPublicKey [bits=" + bits + ", m=" + Arrays.toString(m) + ", e=" + Arrays.toString(e) + "]";
	}

}
