package com.xdja.pki.gmssl.sdf.yunhsm;

import com.xdja.hsm.api.bean.*;
import com.xdja.pki.gmssl.core.utils.GMSSLBCAeadUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.AbstractSdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.*;
import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnection;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunhsmSdfSDK extends AbstractSdfSDK {

    static {
        HsmConnectionProviderImpl.getInstance();
    }

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private HsmConnection connection;

//    private SdfApi sdfApi = new SdfApi();

    @Override
    public void init() throws SdfSDKException {
//        if (ses == null || ses.length == 0 || ses[0] == 0) {
//            //获取配置文件
//            String cfg = System.getenv("YUNHSMSDK_CONF");
//            if (cfg == null) {
//                logger.error("getenv(\"YUNHSMSDK_CONF\") return null, please set this env variable");
//                throw new SdfSDKException("get system config error");
//            }
//
//            //打开设备
//            int ret = sdfApi.openDevice(dev);
//            checkRet("openDevice", ret, connection);
//
//            //使用配置文件初始化设备
//            ret = sdfApi.initialize(dev[0], cfg.getBytes());
//            checkRet("initialize", ret, connection);
//
//            //打开 session
//            ret = sdfApi.openSession(dev[0], ses);
//            checkRet("openSession", ret, connection);
//        }
    }

    @Override
    public void release() throws SdfSDKException {
//        int ret = sdfApi.closeSession(ses[0]);
//        checkRet("closeSession", ret, connection);
//        ret = sdfApi.closeDevice(dev[0]);
//        checkRet("closeDevice", ret, connection);
//        this.dev = new long[]{0};
//        this.ses = new long[]{0};
    }

    protected void checkRet(String method, int ret, boolean release) throws SdfSDKException {
        long dev = connection.getDev()[0];
        long ses = connection.getSes()[0];
        if (release) {
            releaseConnection();
        }
        YunhsmSdfSDKUtils.checkRet(method, ret, dev, ses);
    }

    public void releaseConnection() {
        if (connection != null) {
//            HsmConnectionPool.getInstance().releaseConnection(connection);
            HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
            connection = null;
        }
    }

    @Override
    public byte[] generateRandom(int uiLength) throws SdfSDKException {
        byte[] pucRandom = new byte[uiLength];
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateRandom(connection.getSes()[0], uiLength, pucRandom);
        }
        checkRet("generateRandom uiLength " + uiLength, ret, true);
        return pucRandom;
    }

    @Override
    public SdfECCKeyPair generateKeyPairEcc() throws SdfSDKException {
        //ECC签名公钥  ECC加密公钥
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], AlgId.SGD_SM2, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        }
        checkRet("generateKeyPairEcc", ret, true);
//        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucPrivateKey.getK());
        return new SdfECCKeyPair(
                SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY()),
                SdfECCPrivateKey.getInstanceFilterHead(pucPrivateKey.getK())
        );
    }


    @Override
    public SdfECCKeyPair generateKeyPairEcc(int algId) throws SdfSDKException {
        //ECC签名公钥  ECC加密公钥
        EccPublicKey pucPublicKey = new EccPublicKey();
        EccPrivateKey pucPrivateKey = new EccPrivateKey();
        connection = HsmConnectionProviderImpl.getInstance().getConnection();

        int ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], algId, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyPairEcc(connection.getSes()[0], algId, GMSSLX509Utils.ECC_KEY_BITS, pucPublicKey, pucPrivateKey);
        }
        checkRet("generateKeyPairEcc", ret, true);
//        byte[] k = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucPrivateKey.getK());
        return new SdfECCKeyPair(
                SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY()),
                SdfECCPrivateKey.getInstanceFilterHead(pucPrivateKey.getK())
        );
    }

    @Override
    public boolean checkPrivateKeyAccessRight(int index, byte[] password) throws SdfSDKException {
        boolean result = false;
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
//        connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        releaseConnection();
        if (ret == SdfApiCode.SDR_OK) {
            result = true;
        }

        return result;
    }

    private void getPrivateKeyAccessRight(HsmConnection connection, int index, byte[] password) throws SdfSDKException {
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
        }
        // 私钥访问控制码错误
        if (ret == SdfApiCode.SDR_PRKRERR) {
            logger.debug("getPrivateKeyAccessRight fail password may be wrong, index={} password={}", index, new String(password));
            return;
        }
        // 私钥访问控制码 竞争
//        if (ret == SdfApiCode.SDR_PARDENY) {
//            for (int i = 0; i < 5; i++) {
//                ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], index, password, password.length);
//                if (ret == SdfApiCode.SDR_PARDENY) {
//                    logger.debug("getPrivateKeyAccessRight fail count {}, index={} password={}", i, index, new String(password));
//                    continue;
//                }
//                if (ret == SdfApiCode.SDR_OK) {
//                    logger.debug("getPrivateKeyAccessRight success count {}", i);
//                    return;
//                }
//            }
//        }
        checkRet("getPrivateKeyAccessRight", ret, false);
    }

    private void releasePrivateKeyAccessRight(HsmConnection connection, int index) throws SdfSDKException {
        int ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().releasePrivateKeyAccessRight(connection.getSes()[0], index);
        }
        checkRet("releasePrivateKeyAccessRight", ret, false);
    }

    @Override
    public SdfECCSignature internalSignECC(int index, byte[] password, byte[] data) throws SdfSDKException {
        EccSignature pucSignature = new EccSignature();
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);

        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
        }
//        while (ret == SdfApiCode.SDR_PARDENY) {
//            logger.debug("internalSignECC get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
//            this.getPrivateKeyAccessRight(connection, index, password);
//            ret = connection.getSdfApi().internalSignEcc(connection.getSes()[0], index, data, data.length, pucSignature);
//        }
//        this.releasePrivateKeyAccessRight(connection, index);

        checkRet("internalSignECC", ret, true);
        byte[] r = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucSignature.getR());
        byte[] s = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucSignature.getS());
        return new SdfECCSignature(r, s);
    }

    @Override
    public SdfECCPublicKey exportSignPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportSignPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportSignPublicKeyEcc", ret, true);
        return SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature) throws SdfSDKException {
        externalVerifyECC(publicKey, data, sdfECCSignature, "SM3WITHSM2");
    }

    @Override
    public void externalVerifyECC(SdfECCPublicKey publicKey, byte[] data, SdfECCSignature sdfECCSignature, String signAlgName) throws SdfSDKException {
        byte[] r = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCSignature.getR());
        byte[] s = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCSignature.getS());
        EccSignature pucSignature = new EccSignature(r, s);
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(publicKey.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(publicKey.getY());
        EccPublicKey pucPublicKey = new EccPublicKey(GMSSLX509Utils.ECC_KEY_BITS, x, y);
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int algId;
        if (signAlgName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (signAlgName.toUpperCase().contains("ECDSA")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support signAlgName " + signAlgName);
        }
        int ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalVerifyEcc(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucSignature);
        }
        checkRet("externalVerifyECC", ret, true);
    }

    @Override
    public SdfECCPublicKey exportEncPublicKeyEcc(int index) throws SdfSDKException {
        EccPublicKey pucPublicKey = new EccPublicKey();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportEncPublicKeyEcc(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportEncPublicKeyEcc index " + index, ret, true);

        return SdfECCPublicKey.getInstanceFilterHead(pucPublicKey.getX(), pucPublicKey.getY());
    }

    @Override
    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data) throws SdfSDKException {
        return externalEncryptECC(publicKey, data, "SM2");
    }

    @Override
    public SdfECCCipher externalEncryptECC(SdfECCPublicKey publicKey, byte[] data, String stdName) throws SdfSDKException {
        EccCipher pucEncData = new EccCipher();
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, publicKey.getX(), publicKey.getY());
        int algId;
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalEncryptEcc(connection.getSes()[0], algId, pucPublicKey, data, data.length, pucEncData);
        }
        checkRet("externalEncryptECC", ret, true);

//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data x", pucEncData.getX());
//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data y", pucEncData.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucEncData.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucEncData.getY());
        return new SdfECCCipher(x, y, pucEncData.getM(), pucEncData.getL(), pucEncData.getC());
    }

    @Override
    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        return internalDecryptECC(index, password, len, sdfECCCipher, "SM2");
    }

    @Override
    public byte[] internalDecryptECC(int index, byte[] password, int len, SdfECCCipher sdfECCCipher, String stdName) throws SdfSDKException {
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getY());
        EccCipher pucEncData = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());
        byte[] pucData = new byte[len];
        int[] puiDataLength = {len};
        int algId;
        if (stdName.toUpperCase().contains("SM2")) {
            algId = AlgId.SGD_SM2;
        } else if (stdName.toUpperCase().contains("P-256")) {
            algId = AlgId.SGD_ECC_NISTP256;
        } else {
            throw new SdfSDKException("un support stdName " + stdName);
        }
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, algId, pucEncData, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, algId, pucEncData, pucData, puiDataLength);
        }

//        while (ret == SdfApiCode.SDR_PARDENY) {
//            logger.debug("internalDecryptECC get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
//            this.getPrivateKeyAccessRight(connection, index, password);
//            ret = connection.getSdfApi().internalDecryptEcc(connection.getSes()[0], index, AlgId.SGD_SM2, pucEncData, pucData, puiDataLength);
//        }
//        this.releasePrivateKeyAccessRight(connection, index);

        checkRet("internalDecryptEcc index " + index + " password " + new String(password), ret, true);

        return pucData;
    }

    @Override
    public SdfECCCipher generateKeyWithEpkEcc(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        this.destroyKey(keyHandle.getHandle());
        return keyHandle.getCipherKey();
    }

    @Override
    public long[] generateKeyWithEpkEccHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle keyHandle = generateKeyWithEpkEccKeyHandle(sdfECCPublicKey);
        return keyHandle.getHandle();
    }

    @Override
    public SdfSymmetricKeyHandle generateKeyWithEpkEccKeyHandle(SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        int uiKeyBits_SES = 128;
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
        EccCipher pucKey = new EccCipher();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyWithEpkEcc(connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyWithEpkEcc(connection.getSes()[0], uiKeyBits_SES, AlgId.SGD_SM2, pucPublicKey, pucKey, phKeyHandle);
        }

        checkRet("generateKeyWithEpkEcc", ret, false);
//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data x", pucKey.getX());
//        GMSSLByteArrayUtils.printHexBinary(logger, "enc data y", pucKey.getY());
        byte[] x = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucKey.getX());
        byte[] y = GMSSLByteArrayUtils.filterByteArrayZeroInHead(pucKey.getY());
        SdfECCCipher cipher = new SdfECCCipher(x, y, pucKey.getM(), pucKey.getL(), pucKey.getC());
        return new SdfSymmetricKeyHandle(cipher, phKeyHandle);
    }

    @Override
    public long[] importKeyWithIskEcc(int uiIskIndex, byte[] password, SdfECCCipher sdfECCCipher) throws SdfSDKException {
        long[] phKeyHandle = {0};
        byte[] x = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getX());
        byte[] y = GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(sdfECCCipher.getY());
        EccCipher pucKey = new EccCipher(x, y, sdfECCCipher.getM(), sdfECCCipher.getL(), sdfECCCipher.getC());

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, uiIskIndex, password);
        int ret = connection.getSdfApi().importKeyWithIskEcc(connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().importKeyWithIskEcc(connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
        }

//        while (ret == SdfApiCode.SDR_PARDENY) {
//            logger.debug("importKeyWithIskEcc get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
//            this.getPrivateKeyAccessRight(connection, uiIskIndex, password);
//            ret = connection.getSdfApi().importKeyWithIskEcc(connection.getSes()[0], uiIskIndex, pucKey, phKeyHandle);
//        }
//        this.releasePrivateKeyAccessRight(connection, uiIskIndex);
        checkRet("importKeyWithIskEcc index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    @Override
    public long[] importKey(byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().importKey(connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().importKey(connection.getSes()[0], pucKey, pucKey.length, phKeyHandle);
        }
        checkRet("importKey", ret, false);
        return phKeyHandle;
    }

    @Override
    public byte[] encrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucData) throws SdfSDKException {
        byte[] pucEncData = new byte[pucData.length];
        int[] puiEncDataLength = {pucData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        logger.info("encrypt connection :"+connection);
        logger.info("encrypt connection session :"+connection.getSes()[0]);
        logger.info("encrypt handle :"+phKeyHandle[0]);
        int ret = connection.getSdfApi().encrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            logger.info("encrypt reopen session");
            connection.reopen();
            ret = connection.getSdfApi().encrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucData, pucData.length, pucEncData, puiEncDataLength);
        }
        checkRet("encrypt", ret, false);
        return pucEncData;
    }

    @Override
    public byte[] decrypt(long[] phKeyHandle, SdfAlgIdSymmetric sdfAlgIdBlockCipher, byte[] iv, byte[] pucEncData) throws SdfSDKException {
        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = {pucEncData.length};
        byte[] pucIv = null;
        if (iv != null) {
            pucIv = new byte[iv.length];
            System.arraycopy(iv, 0, pucIv, 0, iv.length);
        }
        logger.info("decrypt connection :"+connection);
        logger.info("decrypt connection session :"+connection.getSes()[0]);
        logger.info("decrypt handle :"+phKeyHandle[0]);
        int ret = connection.getSdfApi().decrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            logger.info("decrypt error,reopen device");
            connection.reopen();
            ret = connection.getSdfApi().decrypt(connection.getSes()[0], phKeyHandle[0], sdfAlgIdBlockCipher.getId(), pucIv, pucEncData, pucEncData.length, pucData, puiDataLength);
        }
        checkRet("decrypt", ret, false);
        return pucData;
    }

    @Override
    public void destroyKey(long[] phKeyHandle) throws SdfSDKException {
        if (connection != null) {
            int ret = connection.getSdfApi().destroyKey(connection.getSes()[0], phKeyHandle[0]);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                connection.reopen();
                ret = connection.getSdfApi().destroyKey(connection.getSes()[0], phKeyHandle[0]);
            }
            checkRet("destroyKey", ret, true);
        }
    }

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash) throws SdfSDKException {
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), null, null, 0);
        }
        checkRet("hashInit", ret, false);
    }

    @Override
    public void hashInit(SdfAlgIdHash sdfAlgIdHash, byte[] pucID, SdfECCPublicKey sdfECCPublicKey) throws SdfSDKException {
        EccPublicKey pucPublicKey = YunhsmSdfSDKUtils.generateEccPublicKey(logger, sdfECCPublicKey);
//        logger.info("hashInit session {}", connection.getSes()[0]);
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().hashInit(connection.getSes()[0], sdfAlgIdHash.getId(), pucPublicKey, pucID, pucID.length);
        }
        checkRet("hashInit pucID " + new String(pucID), ret, false);
    }

    @Override
    public void hashUpdate(byte[] data) throws SdfSDKException {
        if (data.length == 0) {
            logger.debug("hashUpdate data length == 0");
            return;
        }
//        logger.info("hashUpdate session {}", connection.getSes()[0]);
        int ret = connection.getSdfApi().hashUpdate(connection.getSes()[0], data, data.length);
        checkRet("hashUpdate", ret, false);
    }

    @Override
    public byte[] hashFinal(int digestLen) throws SdfSDKException {
        byte[] pucHash = new byte[digestLen];
        int[] pucHashLen = {pucHash.length};
        if (connection != null) {
//            logger.info("hashFinal session {}", connection.getSes()[0]);
            int ret = connection.getSdfApi().hashFinal(connection.getSes()[0], pucHash, pucHashLen);
            if (ret == SdfApiCode.SDR_COMMFAIL) {
                connection.reopen();
                ret = connection.getSdfApi().hashFinal(connection.getSes()[0], pucHash, pucHashLen);
            }
//            releaseConnection();
            checkRet("hashFinal digestLen " + digestLen, ret, true);
        }
        return pucHash;
    }

    @Override
    public void calculateMac(int uiKeyIndex) throws SdfSDKException {
        int ret;
        int uiKeyBits_SES = 128;

        long[] phKeyHandle = {0};
        EccCipher pucKey = new EccCipher();

        //对称算法运算类函数缓冲区指针定义
        byte[] pucIV = new byte[1024];
        byte[] pucEncDate = new byte[1024];
        int[] pucEncDateLen = {1024};

        //要加密的数据 和数据长度
        String pucDate_t = "12345678123456781234567812345678";
        byte[] pucDate = pucDate_t.getBytes();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        ret = connection.getSdfApi().generateKeyWithIpkEcc(connection.getSes()[0], uiKeyIndex, uiKeyBits_SES, pucKey, phKeyHandle);
        checkRet("generateKeyWithIpkEcc", ret, false);
        ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().calculateMac(connection.getSes()[0], phKeyHandle[0], AlgId.SGD_SM4_MAC, pucIV, pucDate, pucDate.length, pucEncDate, pucEncDateLen);
        }

        checkRet("calculateMac uiKeyIndex " + uiKeyIndex, ret, true);
    }

    @Override
    public byte[] sm3Hmac(byte[] dataIn, byte[] key) throws SdfSDKException {
        throw new SdfSDKException("yunhsm unsupport sm3 hmac");
    }

    public void testConnect() throws SdfSDKException {
        YunhsmSdfSDKUtils.testConnection(null);
    }

    public void testConnect(String configPath) throws SdfSDKException {
        YunhsmSdfSDKUtils.testConnection(configPath);
    }

    @Override
    public SdfRSAPublicKey exportSignPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportSignPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportSignPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportSignPublicKeyRsa", ret, true);
        return SdfRSAPublicKey.getInstanceFilterHead(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRSAPublicKey exportEncPublicKeyRsa(int index) throws SdfSDKException {
        RsaPublicKey pucPublicKey = new RsaPublicKey();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().exportEncPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().exportEncPublicKeyRsa(connection.getSes()[0], index, pucPublicKey);
        }
        checkRet("exportEncPublicKeyRsa index " + index, ret, true);
        return SdfRSAPublicKey.getInstanceFilterHead(pucPublicKey.getBits(), pucPublicKey.getM(), pucPublicKey.getE());
    }

    @Override
    public SdfRsaKeyPair generateKeyPairRsa(int bits) throws SdfSDKException {
        RsaPublicKey rsaPublicKey = new RsaPublicKey();
        RsaPrivateKey rsaPrivateKey = new RsaPrivateKey();

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyPairRsa(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyPairRsa(connection.getSes()[0], bits, rsaPublicKey, rsaPrivateKey);
        }
        checkRet("generateKeyPairRsa bits " + bits, ret, true);
        SdfRSAPrivateKey sdfRSAPrivateKey = new SdfRSAPrivateKey(rsaPrivateKey.getBits(), rsaPrivateKey.getM(), rsaPrivateKey.getE(), rsaPrivateKey.getD(),
                rsaPrivateKey.getPrime(), rsaPrivateKey.getPexp(), rsaPrivateKey.getCoef());
        SdfRSAPublicKey sdfRSAPublicKey = new SdfRSAPublicKey(rsaPublicKey.getBits(), rsaPublicKey.getM(), rsaPublicKey.getE());
        return new SdfRsaKeyPair(sdfRSAPrivateKey, sdfRSAPublicKey);
    }

    @Override
    public byte[] externalPublicKeyOperationRsa(SdfRSAPublicKey sdfRSAPublicKey, byte[] data) throws SdfSDKException {
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = {bitLen};

        RsaPublicKey rsaPublicKey = YunhsmSdfSDKUtils.generateRsaPublicKey(logger, sdfRSAPublicKey);

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalPublicKeyOperationRsa(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().externalPublicKeyOperationRsa(connection.getSes()[0], rsaPublicKey, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
        checkRet("externalPublicKeyOperationRsa", ret, true);
        return pucDataOutPut;
    }

    @Override
    public byte[] internalPrivateKeyOperationRsa(int index, byte[] password, byte[] data) throws SdfSDKException {
        SdfRSAPublicKey sdfRSAPublicKey = this.exportSignPublicKeyRsa(index);
        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucDataOutPut = new byte[bitLen];
        int[] puiDataOutPutLength = {bitLen};

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, index, password);
        int ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
        }
//        while (ret == SdfApiCode.SDR_PARDENY) {
//            logger.debug("internalPrivateKeyOperationRsa get private key access error 0x01000007 {} !", SdfApiCode.apiCodeToString(ret));
//            this.getPrivateKeyAccessRight(connection, index, password);
//            ret = connection.getSdfApi().internalPrivateKeyOperationRsa(connection.getSes()[0], index, data, data.length, pucDataOutPut, puiDataOutPutLength);
//        }

        checkRet("internalPrivateKeyOperationRsa index " + index + " password " + new String(password), ret, true);
        return pucDataOutPut;
    }

    @Override
    public byte[] encryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] data) throws SdfSDKException {
        byte[] pucTag = new byte[tagLen];
        byte[] pucEncData = new byte[data.length];
        int[] puiEncDataLength = new int[]{pucEncData.length};

        //encryptAead(long hSessionHandle, long hKeyHandle, int uiAlgId,
        // byte[] nonce, int uiNonceLength,
        // byte[] pucAddData, int uiAdataLength,
        // byte[] pucData, int uiDataLength,
        // byte[] pucTag, int uiTagLength,
        // byte[] pucEncData, int[] puiEncDataLength);
        if (null == nonce) {
            nonce = new byte[0];
        }
        if (null == aad) {
            aad = new byte[0];
        }
        int ret = connection.getSdfApi().encryptAead(
                connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(),
                nonce, nonce.length,
                aad, aad.length,
                data, data.length,
                pucTag, pucTag.length,
                pucEncData, puiEncDataLength
        );
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().encryptAead(
                    connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(),
                    nonce, nonce.length,
                    aad, aad.length,
                    data, data.length,
                    pucTag, pucTag.length,
                    pucEncData, puiEncDataLength
            );
        }
        checkRet("encrypt aead", ret, true);

        return GMSSLBCAeadUtils.pieceCipherTag(pucEncData, pucTag);
    }

    @Override
    public byte[] decryptAead(long[] phKeyHandle, SdfAlgIdAead uiAlgId, int tagLen, byte[] nonce, byte[] aad, byte[] enc) throws SdfSDKException {
        byte[][] cipher = GMSSLBCAeadUtils.splitCipherTag(enc, tagLen);

        byte[] pucEncData = cipher[0];
        byte[] pucTag = cipher[1];


        byte[] pucData = new byte[pucEncData.length];
        int[] puiDataLength = new int[]{pucData.length};

        //decryptAead(long hSessionHandle, long hKeyHandle, int uiAlgId,
        // byte[] nonce, int uiNonceLength,
        // byte[] pucAddData, int uiAdataLength,
        // byte[] pucEncData, int uiEncDataLength,
        // byte[] pucTag, int uiTagLength,
        // byte[] pucData, int[] puiDataLength);
        if (null == nonce) {
            nonce = new byte[0];
        }
        if (null == aad) {
            aad = new byte[0];
        }
        int ret = connection.getSdfApi().decryptAead(
                connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(),
                nonce, nonce.length,
                aad, aad.length,
                pucEncData, pucEncData.length,
                pucTag, pucTag.length,
                pucData, puiDataLength
        );
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().decryptAead(
                    connection.getSes()[0], phKeyHandle[0], uiAlgId.getId(),
                    nonce, nonce.length,
                    aad, aad.length,
                    pucEncData, pucEncData.length,
                    pucTag, pucTag.length,
                    pucData, puiDataLength
            );
        }
        checkRet("encrypt aead", ret, true);

        return pucData;
    }

    @Override
    public long[] importKeyWithKek(SdfAlgIdSymmetric uiAlgId, int uiKekIndex, byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        logger.info("import Key with kek connection :"+connection);
        logger.info("import Key with kek connection session :"+connection.getSes()[0]);
        int ret = connection.getSdfApi().importKeyWithKek(connection.getSes()[0], uiAlgId.getId(), uiKekIndex, pucKey, pucKey.length, phKeyHandle);
        logger.info("import Key with kek encrypt handle :"+phKeyHandle[0]);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            logger.info("import Key with kek reopen");
            connection.reopen();
            ret = connection.getSdfApi().importKeyWithKek(connection.getSes()[0], uiAlgId.getId(), uiKekIndex, pucKey, pucKey.length, phKeyHandle);
        }
        checkRet("importKeyWithKek", ret, false);
        return phKeyHandle;
    }

    @Override
    public byte[] generateKeyWithEpkRsa(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle sdfSymmetricKeyHandle = generateKeyWithEpkRsaKeyHandle(sdfRSAPublicKey);
        this.destroyKey(sdfSymmetricKeyHandle.getHandle());
        return sdfSymmetricKeyHandle.getRsaCipherKey();
    }

    @Override
    public long[] generateKeyWithEpkRsaHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        SdfSymmetricKeyHandle sdfSymmetricKeyHandle = generateKeyWithEpkRsaKeyHandle(sdfRSAPublicKey);
        return sdfSymmetricKeyHandle.getHandle();
    }

    @Override
    public SdfSymmetricKeyHandle generateKeyWithEpkRsaKeyHandle(SdfRSAPublicKey sdfRSAPublicKey) throws SdfSDKException {
        long[] phKeyHandle = {0};
        int uiKeyBits_SES = 128;
        RsaPublicKey rsaPublicKey = YunhsmSdfSDKUtils.generateRsaPublicKey(logger, sdfRSAPublicKey);

        int bitLen = sdfRSAPublicKey.getBits() / 8;
        byte[] pucKey = new byte[bitLen];
        int[] puiKeyLength = {bitLen};

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        //        public native int generateKeyWithEpkRsa(long hSessionHandle, int uiKeyBits, RsaPublicKey pucPublicKey, byte[] pucKey, int[] puiKeyLength, long[] phKeyHandle);
        int ret = connection.getSdfApi().generateKeyWithEpkRsa(connection.getSes()[0], uiKeyBits_SES, rsaPublicKey, pucKey, puiKeyLength, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyWithEpkRsa(connection.getSes()[0], uiKeyBits_SES, rsaPublicKey, pucKey, puiKeyLength, phKeyHandle);
        }

        checkRet("generateKeyWithEpkRsa", ret, false);
        return new SdfSymmetricKeyHandle(pucKey, phKeyHandle);
    }

    @Override
    public long[] importKeyWithIskRsa(int uiIskIndex, byte[] password, byte[] pucKey) throws SdfSDKException {
        long[] phKeyHandle = {0};

        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        this.getPrivateKeyAccessRight(connection, uiIskIndex, password);
        int ret = connection.getSdfApi().importKeyWithIskRsa(connection.getSes()[0], uiIskIndex, pucKey, pucKey.length, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().importKeyWithIskRsa(connection.getSes()[0], uiIskIndex, pucKey, pucKey.length, phKeyHandle);
        }
        checkRet("importKeyWithIskRsa index " + uiIskIndex + " password " + new String(password), ret, false);
        return phKeyHandle;
    }

    @Override
    public byte[] generateKeyWithKek(int uiAlgId, int uiKekIndex) throws SdfSDKException {
        long[] phKeyHandle = {0};
        int uiKeyBits_SES = 128;
        byte[] pucKey = new byte[uiKeyBits_SES / 8];
        int[] puiKeyLength = {uiKeyBits_SES / 8};
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().generateKeyWithKek(connection.getSes()[0], uiKeyBits_SES, uiAlgId, uiKekIndex, pucKey, puiKeyLength, phKeyHandle);
        if (ret == SdfApiCode.SDR_COMMFAIL) {
            connection.reopen();
            ret = connection.getSdfApi().generateKeyWithKek(connection.getSes()[0], uiKeyBits_SES, uiAlgId, uiKekIndex, pucKey, puiKeyLength, phKeyHandle);
        }
        checkRet("generateKeyWithKek index " + uiKekIndex, ret, false);
        return pucKey;
    }
}
