package com.xdja.pki.gmssl.sdf.yunhsm.pool;

import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.DeviceInfo;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmConnection {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private SdfApi sdfApi;
    private long[] dev;

    private volatile long[] ses = {0};
    private int id;
    private long startTime;

    public HsmConnection(SdfApi sdfApi, long[] dev) throws SdfSDKException {
        this.sdfApi = sdfApi;
        this.dev = dev;
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, ses);
    }

    public SdfApi getSdfApi() {
        return sdfApi;
    }

    public long[] getDev() {
        return dev;
    }

    public long[] getSes() {
        return ses;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void reopen() throws SdfSDKException {
        YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
        this.ses = new long[]{0};
        YunhsmSdfSDKUtils.openSession(sdfApi, dev, ses);
    }

    public synchronized void close() throws SdfSDKException {
        YunhsmSdfSDKUtils.closeSession(sdfApi, dev, ses);
        this.ses = new long[]{0};
    }

    public String getDeviceInfo() throws SdfSDKException {
        return YunhsmSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
    }

    public boolean isConnection() {
        try {
            YunhsmSdfSDKUtils.getDeviceInfo(sdfApi, dev, ses);
            return true;
        } catch (SdfSDKException e) {
            logger.debug("getDeviceInfo dev = {} session = {}, error={}", dev[0], ses[0], e);
            return false;
        }
    }

}
