package com.xdja.pki.gmssl.sdf.yunhsm.pool;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author sxy
 * @description
 * @date 2019年11月14日 22:44
 **/
public class HsmPooledObjectFactory implements PooledObjectFactory<HsmConnection> {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private volatile SdfApi sdfApi = new SdfApi();
    private volatile long[] dev = {0};

    HsmPooledObjectFactory() {
        openDevice();
    }

    synchronized boolean isDeviceOpen() {
        return this.dev[0] != 0;
    }

    synchronized void openDevice() {
        if (!isDeviceOpen()) {
            String configPath = YunhsmSdfSDKUtils.getConfigPath();
            if (configPath != null) {
                try {
                    YunhsmSdfSDKUtils.openDevice(this.sdfApi, this.dev);
                } catch (SdfSDKException e) {
                    logger.error("hsm pool init openDevice error", e);
                }
                try {
                    YunhsmSdfSDKUtils.initialize(this.sdfApi, this.dev, configPath);
                } catch (SdfSDKException e) {
                    logger.error("hsm pool init initialize error", e);
                }
                logger.debug("openDevice dev = {} session = {}", dev[0]);
            }
        } else {
            logger.error("hsm pool open device but dev={}", dev[0]);
        }
    }

    synchronized void closeDevice() {
        if (this.dev[0] != 0) {
            try {
                YunhsmSdfSDKUtils.closeDevice(this.sdfApi, this.dev);
                logger.debug("closeDevice dev = {} session = {}", dev[0]);
            } catch (SdfSDKException e) {
                logger.error("hsm pool init closeDevice error", e);
            }
        }
        this.dev = new long[]{0};
    }

    @Override
    public PooledObject<HsmConnection> makeObject() throws Exception {
        if (this.dev[0] == 0) {
            logger.error("make hsm connection device is not open! now open it!");
            openDevice();
        }
        HsmConnection connection = new HsmConnection(this.sdfApi, this.dev);
        return new DefaultPooledObject<>(connection);
    }

    @Override
    public void destroyObject(PooledObject<HsmConnection> pooledObject) throws Exception {
        HsmConnection connection = pooledObject.getObject();
        if (connection.isConnection()) {
            connection.close();
        }
    }

    @Override
    public boolean validateObject(PooledObject<HsmConnection> pooledObject) {
        HsmConnection connection = pooledObject.getObject();
        return connection.isConnection();
    }

    @Override
    public void activateObject(PooledObject<HsmConnection> pooledObject) throws Exception {

    }

    @Override
    public void passivateObject(PooledObject<HsmConnection> pooledObject) throws Exception {

    }

}
